/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi.split;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.util.AsyncQueue;
import com.facebook.presto.hudi.HudiFile;
import com.facebook.presto.hudi.HudiMetadata;
import com.facebook.presto.hudi.HudiPartition;
import com.facebook.presto.hudi.HudiSessionProperties;
import com.facebook.presto.hudi.HudiSplit;
import com.facebook.presto.hudi.HudiSplitManager;
import com.facebook.presto.hudi.HudiTableHandle;
import com.facebook.presto.hudi.HudiTableLayoutHandle;
import com.facebook.presto.hudi.HudiTableType;
import com.facebook.presto.hudi.split.HudiSplitWeightProvider;
import com.facebook.presto.hudi.split.SizeBasedSplitWeightProvider;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.HoodieTimer;

public class HudiPartitionSplitGenerator
implements Runnable {
    private static final Logger log = Logger.get(HudiPartitionSplitGenerator.class);
    private final ExtendedHiveMetastore metastore;
    private final MetastoreContext metastoreContext;
    private final HudiTableLayoutHandle layout;
    private final HudiTableHandle table;
    private final Path tablePath;
    private final HoodieTableFileSystemView fsView;
    private final AsyncQueue<ConnectorSplit> asyncQueue;
    private final Queue<String> concurrentPartitionQueue;
    private final String latestInstant;
    private final HudiSplitWeightProvider splitWeightProvider;

    public HudiPartitionSplitGenerator(ConnectorSession session, ExtendedHiveMetastore metastore, HudiTableLayoutHandle layout, HoodieTableFileSystemView fsView, AsyncQueue<ConnectorSplit> asyncQueue, Queue<String> concurrentPartitionQueue, String latestInstant) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.metastoreContext = HudiMetadata.toMetastoreContext(Objects.requireNonNull(session, "session is null"));
        this.layout = Objects.requireNonNull(layout, "layout is null");
        this.table = layout.getTable();
        this.tablePath = new Path(this.table.getPath());
        this.fsView = Objects.requireNonNull(fsView, "fsView is null");
        this.asyncQueue = Objects.requireNonNull(asyncQueue, "asyncQueue is null");
        this.concurrentPartitionQueue = Objects.requireNonNull(concurrentPartitionQueue, "concurrentPartitionQueue is null");
        this.latestInstant = Objects.requireNonNull(latestInstant, "latestInstant is null");
        this.splitWeightProvider = HudiPartitionSplitGenerator.createSplitWeightProvider(Objects.requireNonNull(session, "session is null"));
    }

    @Override
    public void run() {
        HoodieTimer timer = new HoodieTimer().startTimer();
        while (!this.concurrentPartitionQueue.isEmpty()) {
            String partitionName = this.concurrentPartitionQueue.poll();
            if (partitionName == null) continue;
            this.generateSplitsFromPartition(partitionName);
        }
        log.debug("Partition split generator finished in %d ms", new Object[]{timer.endTimer()});
    }

    private void generateSplitsFromPartition(String partitionName) {
        HudiPartition hudiPartition = HudiSplitManager.getHudiPartition(this.metastore, this.metastoreContext, this.layout, partitionName);
        Path partitionPath = new Path(hudiPartition.getStorage().getLocation());
        String relativePartitionPath = FSUtils.getRelativePartitionPath((Path)this.tablePath, (Path)partitionPath);
        this.fsView.getLatestFileSlicesBeforeOrOn(relativePartitionPath, this.latestInstant, false).map(fileSlice -> this.createHudiSplit(this.table, (FileSlice)fileSlice, this.latestInstant, hudiPartition, this.splitWeightProvider)).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> this.asyncQueue.offer(arg_0));
    }

    private Optional<HudiSplit> createHudiSplit(HudiTableHandle table, FileSlice slice, String timestamp, HudiPartition partition, HudiSplitWeightProvider splitWeightProvider) {
        HudiFile baseFile = (HudiFile)slice.getBaseFile().map(f -> new HudiFile(f.getPath(), 0L, f.getFileLen())).orElse(null);
        if (null == baseFile && table.getTableType() == HudiTableType.COW) {
            return Optional.empty();
        }
        List logFiles = (List)slice.getLogFiles().map(logFile -> new HudiFile(logFile.getPath().toString(), 0L, logFile.getFileSize())).collect(ImmutableList.toImmutableList());
        long logFilesSize = logFiles.size() > 0 ? logFiles.stream().map(HudiFile::getLength).reduce(0L, Long::sum) : 0L;
        long sizeInBytes = baseFile != null ? baseFile.getLength() + logFilesSize : logFilesSize;
        return Optional.of(new HudiSplit(table, timestamp, partition, Optional.ofNullable(baseFile), logFiles, (List<HostAddress>)ImmutableList.of(), NodeSelectionStrategy.NO_PREFERENCE, splitWeightProvider.calculateSplitWeight(sizeInBytes)));
    }

    private static HudiSplitWeightProvider createSplitWeightProvider(ConnectorSession session) {
        if (HudiSessionProperties.isSizeBasedSplitWeightsEnabled(session)) {
            DataSize standardSplitWeightSize = HudiSessionProperties.getStandardSplitWeightSize(session);
            double minimumAssignedSplitWeight = HudiSessionProperties.getMinimumAssignedSplitWeight(session);
            return new SizeBasedSplitWeightProvider(minimumAssignedSplitWeight, standardSplitWeightSize);
        }
        return HudiSplitWeightProvider.uniformStandardWeightProvider();
    }
}

