/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi.split;

import com.facebook.presto.hudi.split.HudiSplitWeightProvider;
import com.facebook.presto.spi.SplitWeight;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import io.airlift.units.DataSize;
import java.util.Objects;

public class SizeBasedSplitWeightProvider
implements HudiSplitWeightProvider {
    private final double minimumWeight;
    private final double standardSplitSizeInBytes;

    public SizeBasedSplitWeightProvider(double minimumWeight, DataSize standardSplitSize) {
        Preconditions.checkArgument((Double.isFinite(minimumWeight) && minimumWeight > 0.0 && minimumWeight <= 1.0 ? 1 : 0) != 0, (String)"minimumWeight must be > 0 and <= 1, found: %s", (Object)minimumWeight);
        this.minimumWeight = minimumWeight;
        long standardSplitSizeInBytesLong = Objects.requireNonNull(standardSplitSize, "standardSplitSize is null").toBytes();
        Preconditions.checkArgument((standardSplitSizeInBytesLong > 0L ? 1 : 0) != 0, (String)"standardSplitSize must be > 0, found: %s", (Object)standardSplitSize);
        this.standardSplitSizeInBytes = standardSplitSizeInBytesLong;
    }

    @Override
    public SplitWeight calculateSplitWeight(long splitSizeInBytes) {
        double computedWeight = (double)splitSizeInBytes / this.standardSplitSizeInBytes;
        return SplitWeight.fromProportion((double)Doubles.constrainToRange((double)computedWeight, (double)this.minimumWeight, (double)1.0));
    }
}

