/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.GenericHiveRecordCursor;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hudi.HudiColumnHandle;
import com.facebook.presto.spi.RecordCursor;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordReader;

public final class HudiRecordCursors {
    private HudiRecordCursors() {
    }

    public static RecordCursor createRecordCursor(Configuration configuration, Path path, RecordReader<?, ? extends Writable> recordReader, long totalBytes, Properties hiveSchema, List<HudiColumnHandle> hiveColumnHandles, ZoneId hiveStorageTimeZone, TypeManager typeManager) {
        return new GenericHiveRecordCursor(configuration, path, recordReader, totalBytes, hiveSchema, HudiRecordCursors.toHiveColumnHandles(hiveColumnHandles), hiveStorageTimeZone, typeManager);
    }

    private static List<HiveColumnHandle> toHiveColumnHandles(List<HudiColumnHandle> columns) {
        return columns.stream().map(column -> new HiveColumnHandle(column.getName(), column.getHiveType(), column.getHiveType().getTypeSignature(), column.getId(), HiveColumnHandle.ColumnType.REGULAR, column.getComment(), Optional.empty())).collect(Collectors.toList());
    }
}

