/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.cache.CacheFactory;
import com.facebook.presto.cache.CacheStats;
import com.facebook.presto.cache.ForCachingFileSystem;
import com.facebook.presto.cache.filemerge.FileMergeCacheConfig;
import com.facebook.presto.hive.DynamicConfigurationProvider;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.ForCachingHiveMetastore;
import com.facebook.presto.hive.ForMetastoreHdfsEnvironment;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationInitializer;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HiveNodePartitioningProvider;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.PartitionMutator;
import com.facebook.presto.hive.cache.HiveCachingHdfsConfiguration;
import com.facebook.presto.hive.gcs.GcsConfigurationInitializer;
import com.facebook.presto.hive.gcs.HiveGcsConfig;
import com.facebook.presto.hive.gcs.HiveGcsConfigurationInitializer;
import com.facebook.presto.hive.metastore.HiveMetastoreCacheStats;
import com.facebook.presto.hive.metastore.HivePartitionMutator;
import com.facebook.presto.hive.metastore.MetastoreCacheStats;
import com.facebook.presto.hive.metastore.MetastoreConfig;
import com.facebook.presto.hudi.HudiConfig;
import com.facebook.presto.hudi.HudiConnector;
import com.facebook.presto.hudi.HudiMetadataFactory;
import com.facebook.presto.hudi.HudiPageSourceProvider;
import com.facebook.presto.hudi.HudiPartitionManager;
import com.facebook.presto.hudi.HudiSessionProperties;
import com.facebook.presto.hudi.HudiSplitManager;
import com.facebook.presto.hudi.HudiTransactionManager;
import com.facebook.presto.hudi.split.ForHudiBackgroundSplitLoader;
import com.facebook.presto.hudi.split.ForHudiSplitAsyncQueue;
import com.facebook.presto.hudi.split.ForHudiSplitSource;
import com.facebook.presto.plugin.base.security.AllowAllAccessControl;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorSplitManager;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeNodePartitioningProvider;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Singleton;
import javax.management.MBeanServer;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.ExportBinder;
import org.weakref.jmx.testing.TestingMBeanServer;

public class HudiModule
implements Module {
    private final ClassLoader classLoader;
    private final String connectorId;

    public HudiModule(ClassLoader classLoader, String connectorId) {
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
    }

    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(HiveClientConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(MetastoreConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(HudiConfig.class);
        binder.bind(HdfsEnvironment.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(CacheConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(FileMergeCacheConfig.class);
        binder.bind(CacheStats.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(MetastoreClientConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(HiveGcsConfig.class);
        binder.bind(GcsConfigurationInitializer.class).to(HiveGcsConfigurationInitializer.class).in(Scopes.SINGLETON);
        binder.bind(HdfsConfiguration.class).annotatedWith(ForMetastoreHdfsEnvironment.class).to(HiveCachingHdfsConfiguration.class).in(Scopes.SINGLETON);
        binder.bind(HdfsConfiguration.class).annotatedWith(ForCachingFileSystem.class).to(HiveHdfsConfiguration.class).in(Scopes.SINGLETON);
        binder.bind(PartitionMutator.class).to(HivePartitionMutator.class).in(Scopes.SINGLETON);
        binder.bind(MetastoreCacheStats.class).to(HiveMetastoreCacheStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(MetastoreCacheStats.class).as(ObjectNames.generatedNameOf(MetastoreCacheStats.class, (String)this.connectorId));
        binder.bind(MBeanServer.class).toInstance((Object)new TestingMBeanServer());
        binder.bind(HdfsConfigurationInitializer.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, DynamicConfigurationProvider.class);
        binder.bind(CacheFactory.class).in(Scopes.SINGLETON);
        binder.bind(HudiTransactionManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorSplitManager.class).to(HudiSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSourceProvider.class).to(HudiPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorNodePartitioningProvider.class).to(HiveNodePartitioningProvider.class).in(Scopes.SINGLETON);
        binder.bind(HudiMetadataFactory.class).in(Scopes.SINGLETON);
        binder.bind(HudiPartitionManager.class).in(Scopes.SINGLETON);
        binder.bind(FileFormatDataSourceStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(FileFormatDataSourceStats.class).withGeneratedName();
        binder.bind(HudiSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorAccessControl.class).to(AllowAllAccessControl.class).in(Scopes.SINGLETON);
    }

    @ForCachingHiveMetastore
    @Singleton
    @Provides
    public ExecutorService createCachingHiveMetastoreExecutor(MetastoreClientConfig metastoreClientConfig) {
        return Executors.newFixedThreadPool(metastoreClientConfig.getMaxMetastoreRefreshThreads(), Threads.daemonThreadsNamed((String)"hive-metastore-hudi-%s"));
    }

    @ForHudiSplitAsyncQueue
    @Singleton
    @Provides
    public ExecutorService createHudiSplitManagerExecutor() {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"hudi-split-manager-%s"));
    }

    @ForHudiSplitSource
    @Singleton
    @Provides
    public ScheduledExecutorService createSplitLoaderExecutor(HudiConfig hudiConfig) {
        return Executors.newScheduledThreadPool(hudiConfig.getSplitLoaderParallelism(), Threads.daemonThreadsNamed((String)"hudi-split-loader-%s"));
    }

    @ForHudiBackgroundSplitLoader
    @Singleton
    @Provides
    public ExecutorService createSplitGeneratorExecutor(HudiConfig hudiConfig) {
        return Executors.newFixedThreadPool(hudiConfig.getSplitGeneratorParallelism(), Threads.daemonThreadsNamed((String)"hudi-split-generator-%s"));
    }

    @Singleton
    @Provides
    public Connector createConnector(LifeCycleManager lifeCycleManager, HudiTransactionManager hudiTransactionManager, HudiMetadataFactory hudiMetadataFactory, ConnectorSplitManager connectorSplitManager, ConnectorPageSourceProvider connectorPageSourceProvider, ConnectorNodePartitioningProvider connectorNodePartitioningProvider, HudiSessionProperties hudiSessionProperties) {
        return new HudiConnector(lifeCycleManager, hudiTransactionManager, hudiMetadataFactory, (ConnectorSplitManager)new ClassLoaderSafeConnectorSplitManager(connectorSplitManager, this.classLoader), (ConnectorPageSourceProvider)new ClassLoaderSafeConnectorPageSourceProvider(connectorPageSourceProvider, this.classLoader), (ConnectorNodePartitioningProvider)new ClassLoaderSafeNodePartitioningProvider(connectorNodePartitioningProvider, this.classLoader), (ConnectorAccessControl)new AllowAllAccessControl(), hudiSessionProperties);
    }
}

