/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.CacheQuota;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.parquet.HdfsParquetDataSource;
import com.facebook.presto.hive.parquet.ParquetPageSource;
import com.facebook.presto.hive.parquet.ParquetPageSourceFactory;
import com.facebook.presto.hudi.HudiColumnHandle;
import com.facebook.presto.hudi.HudiErrorCode;
import com.facebook.presto.hudi.HudiSessionProperties;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.cache.MetadataReader;
import com.facebook.presto.parquet.predicate.Predicate;
import com.facebook.presto.parquet.predicate.PredicateUtils;
import com.facebook.presto.parquet.reader.ColumnIndexFilterUtils;
import com.facebook.presto.parquet.reader.ParquetReader;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOConverter;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

class HudiParquetPageSources {
    private HudiParquetPageSources() {
    }

    public static ConnectorPageSource createParquetPageSource(TypeManager typeManager, HdfsEnvironment hdfsEnvironment, ConnectorSession session, Configuration configuration, Path path, long start, long length, List<HudiColumnHandle> regularColumns, TupleDomain<HudiColumnHandle> effectivePredicate, FileFormatDataSourceStats fileFormatDataSourceStats) {
        AggregatedMemoryContext systemMemoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        String user = session.getUser();
        boolean readMaskedValue = HudiSessionProperties.getReadNullMaskedParquetEncryptedValue(session);
        HdfsParquetDataSource dataSource = null;
        try {
            HdfsParquetDataSource parquetDataSource;
            ExtendedFileSystem filesystem = hdfsEnvironment.getFileSystem(user, path, configuration);
            FileStatus fileStatus = filesystem.getFileStatus(path);
            long fileSize = fileStatus.getLen();
            long modificationTime = fileStatus.getModificationTime();
            HiveFileContext hiveFileContext = new HiveFileContext(true, CacheQuota.NO_CACHE_CONSTRAINTS, Optional.empty(), OptionalLong.of(fileSize), OptionalLong.of(start), OptionalLong.of(length), modificationTime, false);
            FSDataInputStream inputStream = filesystem.openFile(path, hiveFileContext);
            dataSource = parquetDataSource = HdfsParquetDataSource.buildHdfsParquetDataSource((FSDataInputStream)inputStream, (Path)path, (FileFormatDataSourceStats)fileFormatDataSourceStats);
            Optional fileDecryptor = ParquetPageSourceFactory.createDecryptor((Configuration)configuration, (Path)path);
            ParquetMetadata parquetMetadata = (ParquetMetadata)hdfsEnvironment.doAs(user, () -> HudiParquetPageSources.lambda$createParquetPageSource$0((ParquetDataSource)parquetDataSource, fileSize, fileDecryptor, readMaskedValue));
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            MessageType fileSchema = fileMetaData.getSchema();
            List parquetFields = regularColumns.stream().map(column -> ParquetTypeUtils.getParquetTypeByName((String)column.getName(), (GroupType)fileSchema)).collect(Collectors.toList());
            MessageType requestedSchema = new MessageType(fileSchema.getName(), (List)parquetFields.stream().filter(Objects::nonNull).collect(ImmutableList.toImmutableList()));
            Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)requestedSchema);
            TupleDomain<ColumnDescriptor> parquetTupleDomain = HudiParquetPageSources.getParquetTupleDomain(descriptorsByPath, effectivePredicate);
            Predicate parquetPredicate = PredicateUtils.buildPredicate((MessageType)requestedSchema, parquetTupleDomain, (Map)descriptorsByPath);
            HdfsParquetDataSource finalDataSource = dataSource;
            ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
            ArrayList<Object> blockIndexStores = new ArrayList<Object>();
            for (BlockMetaData block : parquetMetadata.getBlocks()) {
                Optional firstIndex = MetadataReader.findFirstNonHiddenColumnId((BlockMetaData)block);
                if (!firstIndex.isPresent()) continue;
                long firstDataPage = ((ColumnChunkMetaData)block.getColumns().get((Integer)firstIndex.get())).getFirstDataPageOffset();
                Optional columnIndexStore = ColumnIndexFilterUtils.getColumnIndexStore((Predicate)parquetPredicate, (ParquetDataSource)finalDataSource, (BlockMetaData)block, (Map)descriptorsByPath, (boolean)false);
                if (firstDataPage < start || firstDataPage >= start + length || !PredicateUtils.predicateMatches((Predicate)parquetPredicate, (BlockMetaData)block, (ParquetDataSource)dataSource, (Map)descriptorsByPath, parquetTupleDomain, (Optional)columnIndexStore, (boolean)false, Optional.of(session.getWarningCollector()))) continue;
                blocks.add(block);
                blockIndexStores.add(columnIndexStore.orElse(null));
            }
            MessageColumnIO messageColumnIO = ParquetTypeUtils.getColumnIO((MessageType)fileSchema, (MessageType)requestedSchema);
            ParquetReader parquetReader = new ParquetReader(messageColumnIO, blocks, Optional.empty(), (ParquetDataSource)dataSource, systemMemoryContext, HudiSessionProperties.getParquetMaxReadBlockSize(session), HudiSessionProperties.isParquetBatchReadsEnabled(session), HudiSessionProperties.isParquetBatchReaderVerificationEnabled(session), parquetPredicate, blockIndexStores, false, fileDecryptor);
            ImmutableList.Builder namesBuilder = ImmutableList.builder();
            ImmutableList.Builder prestoTypes = ImmutableList.builder();
            ImmutableList.Builder internalFields = ImmutableList.builder();
            for (int columnIndex = 0; columnIndex < regularColumns.size(); ++columnIndex) {
                HudiColumnHandle column2 = regularColumns.get(columnIndex);
                namesBuilder.add((Object)column2.getName());
                Type parquetField = (Type)parquetFields.get(columnIndex);
                com.facebook.presto.common.type.Type prestoType = column2.getHiveType().getType(typeManager);
                prestoTypes.add((Object)prestoType);
                if (parquetField == null) {
                    internalFields.add(Optional.empty());
                    continue;
                }
                internalFields.add((Object)ColumnIOConverter.constructField((com.facebook.presto.common.type.Type)prestoType, (ColumnIO)messageColumnIO.getChild(parquetField.getName())));
            }
            return new ParquetPageSource(parquetReader, (List)prestoTypes.build(), (List)internalFields.build(), (List)namesBuilder.build(), new RuntimeStats());
        }
        catch (Exception e) {
            try {
                if (dataSource != null) {
                    dataSource.close();
                }
            }
            catch (IOException fileStatus) {
                // empty catch block
            }
            if (e instanceof PrestoException) {
                throw (PrestoException)e;
            }
            String message = String.format("Error opening Hudi split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage());
            throw new PrestoException((ErrorCodeSupplier)HudiErrorCode.HUDI_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private static TupleDomain<ColumnDescriptor> getParquetTupleDomain(Map<List<String>, RichColumnDescriptor> descriptorsByPath, TupleDomain<HudiColumnHandle> effectivePredicate) {
        if (effectivePredicate.isNone()) {
            return TupleDomain.none();
        }
        ImmutableMap.Builder predicate = ImmutableMap.builder();
        ((Map)effectivePredicate.getDomains().get()).forEach((columnHandle, domain) -> {
            RichColumnDescriptor descriptor;
            String baseType = columnHandle.getHiveType().getTypeSignature().getBase();
            if (!(baseType.equals("map") || baseType.equals("array") || baseType.equals("row") || (descriptor = (RichColumnDescriptor)descriptorsByPath.get(ImmutableList.of((Object)columnHandle.getName()))) == null)) {
                predicate.put((Object)descriptor, domain);
            }
        });
        return TupleDomain.withColumnDomains((Map)predicate.build());
    }

    private static /* synthetic */ ParquetMetadata lambda$createParquetPageSource$0(ParquetDataSource parquetDataSource, long fileSize, Optional fileDecryptor, boolean readMaskedValue) throws IOException {
        return MetadataReader.readFooter((ParquetDataSource)parquetDataSource, (long)fileSize, (Optional)fileDecryptor, (boolean)readMaskedValue).getParquetMetadata();
    }
}

