/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.presto.hudi.HudiTableType;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class HudiTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final String path;
    private final HudiTableType hudiTableType;

    @JsonCreator
    public HudiTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="path") String path, @JsonProperty(value="tableType") HudiTableType hudiTableType) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.path = Objects.requireNonNull(path, "path is null");
        this.hudiTableType = Objects.requireNonNull(hudiTableType, "tableType is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public HudiTableType getTableType() {
        return this.hudiTableType;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HudiTableHandle that = (HudiTableHandle)o;
        return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && this.hudiTableType == that.hudiTableType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schemaName, this.tableName, this.hudiTableType});
    }

    public String toString() {
        return this.schemaName + "." + this.tableName;
    }
}

