/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi.split;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.util.AsyncQueue;
import com.facebook.presto.hudi.HudiErrorCode;
import com.facebook.presto.hudi.HudiSessionProperties;
import com.facebook.presto.hudi.HudiTableLayoutHandle;
import com.facebook.presto.hudi.split.HudiPartitionSplitGenerator;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.HoodieTimer;

public class HudiBackgroundSplitLoader
implements Runnable {
    private static final Logger log = Logger.get(HudiBackgroundSplitLoader.class);
    private final ConnectorSession session;
    private final ExtendedHiveMetastore metastore;
    private final HudiTableLayoutHandle layout;
    private final HoodieTableFileSystemView fsView;
    private final AsyncQueue<ConnectorSplit> asyncQueue;
    private final List<String> partitions;
    private final String latestInstant;
    private final int splitGeneratorNumThreads;
    private final ExecutorService splitGeneratorExecutorService;

    public HudiBackgroundSplitLoader(ConnectorSession session, ExtendedHiveMetastore metastore, ExecutorService splitGeneratorExecutorService, HudiTableLayoutHandle layout, HoodieTableFileSystemView fsView, AsyncQueue<ConnectorSplit> asyncQueue, List<String> partitions, String latestInstant) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.layout = Objects.requireNonNull(layout, "layout is null");
        this.fsView = Objects.requireNonNull(fsView, "fsView is null");
        this.asyncQueue = Objects.requireNonNull(asyncQueue, "asyncQueue is null");
        this.partitions = Objects.requireNonNull(partitions, "partitions is null");
        this.latestInstant = Objects.requireNonNull(latestInstant, "latestInstant is null");
        this.splitGeneratorNumThreads = HudiSessionProperties.getSplitGeneratorParallelism(session);
        this.splitGeneratorExecutorService = Objects.requireNonNull(splitGeneratorExecutorService, "splitGeneratorExecutorService is null");
    }

    @Override
    public void run() {
        HoodieTimer timer = new HoodieTimer().startTimer();
        ArrayList<HudiPartitionSplitGenerator> splitGeneratorList = new ArrayList<HudiPartitionSplitGenerator>();
        ArrayList splitGeneratorFutures = new ArrayList();
        ConcurrentLinkedQueue<String> concurrentPartitionQueue = new ConcurrentLinkedQueue<String>(this.partitions);
        for (int i = 0; i < this.splitGeneratorNumThreads; ++i) {
            HudiPartitionSplitGenerator hudiPartitionSplitGenerator = new HudiPartitionSplitGenerator(this.session, this.metastore, this.layout, this.fsView, this.asyncQueue, concurrentPartitionQueue, this.latestInstant);
            splitGeneratorList.add(hudiPartitionSplitGenerator);
            splitGeneratorFutures.add(this.splitGeneratorExecutorService.submit(hudiPartitionSplitGenerator));
        }
        for (Future future : splitGeneratorFutures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PrestoException((ErrorCodeSupplier)HudiErrorCode.HUDI_CANNOT_GENERATE_SPLIT, "Error generating Hudi split", (Throwable)e);
            }
        }
        this.asyncQueue.finish();
        log.debug("Finished getting all splits in %d ms", new Object[]{timer.endTimer()});
    }
}

