/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.common.ErrorType;
import com.facebook.presto.spi.ErrorCodeSupplier;

public enum HudiErrorCode implements ErrorCodeSupplier
{
    HUDI_UNKNOWN_TABLE_TYPE(0, ErrorType.INTERNAL_ERROR),
    HUDI_INVALID_METADATA(1, ErrorType.EXTERNAL),
    HUDI_INVALID_PARTITION_VALUE(2, ErrorType.EXTERNAL),
    HUDI_FILESYSTEM_ERROR(64, ErrorType.EXTERNAL),
    HUDI_CANNOT_OPEN_SPLIT(65, ErrorType.EXTERNAL),
    HUDI_CURSOR_ERROR(66, ErrorType.EXTERNAL),
    HUDI_CANNOT_GENERATE_SPLIT(67, ErrorType.EXTERNAL);

    private final ErrorCode errorCode;

    private HudiErrorCode(int code, ErrorType type) {
        this.errorCode = new ErrorCode(code + 0x5050000, this.name(), type);
    }

    public ErrorCode toErrorCode() {
        return this.errorCode;
    }
}

