/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.parquet.Strings;

public class HudiFile {
    private final String path;
    private final long start;
    private final long length;

    @JsonCreator
    public HudiFile(@JsonProperty(value="path") String path, @JsonProperty(value="start") long start, @JsonProperty(value="length") long length) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0, (Object)"path is null or empty");
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start is negative");
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"length is negative");
        this.path = path;
        this.start = start;
        this.length = length;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getLength() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HudiFile hudiFile = (HudiFile)o;
        return this.start == hudiFile.start && this.length == hudiFile.length && this.path.equals(hudiFile.path);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.start, this.length);
    }

    public String toString() {
        return this.path + ":" + this.start + "+" + this.length;
    }
}

