/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.metastore.CachingHiveMetastore;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hudi.HudiMetadata;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import java.util.Objects;
import javax.inject.Inject;

public class HudiMetadataFactory {
    private final ExtendedHiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;
    private final long perTransactionCacheMaximumSize;
    private final boolean metastoreImpersonationEnabled;
    private final int metastorePartitionCacheMaxColumnCount;

    @Inject
    public HudiMetadataFactory(ExtendedHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, TypeManager typeManager, MetastoreClientConfig metastoreClientConfig) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.perTransactionCacheMaximumSize = metastoreClientConfig.getPerTransactionMetastoreCacheMaximumSize();
        this.metastoreImpersonationEnabled = metastoreClientConfig.isMetastoreImpersonationEnabled();
        this.metastorePartitionCacheMaxColumnCount = metastoreClientConfig.getPartitionCacheColumnCountLimit();
    }

    public ConnectorMetadata create() {
        return new HudiMetadata((ExtendedHiveMetastore)CachingHiveMetastore.memoizeMetastore((ExtendedHiveMetastore)this.metastore, (boolean)this.metastoreImpersonationEnabled, (long)this.perTransactionCacheMaximumSize, (int)this.metastorePartitionCacheMaxColumnCount), this.hdfsEnvironment, this.typeManager);
    }
}

