/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hudi.HudiColumnHandle;
import com.facebook.presto.hudi.HudiMetadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class HudiPartitionManager {
    private final TypeManager typeManager;

    @Inject
    public HudiPartitionManager(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public List<String> getEffectivePartitions(ConnectorSession connectorSession, ExtendedHiveMetastore metastore, SchemaTableName schemaTableName, TupleDomain<ColumnHandle> constraintSummary) {
        MetastoreContext metastoreContext = HudiMetadata.toMetastoreContext(connectorSession);
        Optional table = metastore.getTable(metastoreContext, schemaTableName.getSchemaName(), schemaTableName.getTableName());
        Verify.verify((boolean)table.isPresent());
        List partitionColumns = ((Table)table.get()).getPartitionColumns();
        if (partitionColumns.isEmpty()) {
            return ImmutableList.of((Object)"");
        }
        HashMap partitionPredicate = new HashMap();
        Map domains = constraintSummary.getDomains().orElseGet(ImmutableMap::of);
        List<HudiColumnHandle> hudiColumnHandles = HudiMetadata.fromPartitionColumns(partitionColumns);
        for (int i = 0; i < hudiColumnHandles.size(); ++i) {
            HudiColumnHandle column2 = hudiColumnHandles.get(i);
            Column partitionColumn = (Column)partitionColumns.get(i);
            if (domains.containsKey(column2)) {
                partitionPredicate.put(partitionColumn, domains.get(column2));
                continue;
            }
            partitionPredicate.put(partitionColumn, Domain.all((Type)column2.getHiveType().getType(this.typeManager)));
        }
        List partitionNames = metastore.getPartitionNamesByFilter(metastoreContext, schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionPredicate);
        List partitionTypes = partitionColumns.stream().map(column -> this.typeManager.getType(column.getType().getTypeSignature())).collect(Collectors.toList());
        return partitionNames.stream().filter(partitionName -> this.parseValuesAndFilterPartition((String)partitionName, hudiColumnHandles, partitionTypes, constraintSummary)).collect(Collectors.toList());
    }

    private boolean parseValuesAndFilterPartition(String partitionName, List<HudiColumnHandle> partitionColumns, List<Type> partitionColumnTypes, TupleDomain<ColumnHandle> constraintSummary) {
        if (constraintSummary.isNone()) {
            return false;
        }
        Map domains = constraintSummary.getDomains().orElseGet(ImmutableMap::of);
        Map<HudiColumnHandle, NullableValue> partitionValues = HudiPartitionManager.parsePartition(partitionName, partitionColumns, partitionColumnTypes);
        for (HudiColumnHandle column : partitionColumns) {
            NullableValue value = partitionValues.get(column);
            Domain allowedDomain = (Domain)domains.get(column);
            if (allowedDomain == null || allowedDomain.includesNullableValue(value.getValue())) continue;
            return false;
        }
        return true;
    }

    private static Map<HudiColumnHandle, NullableValue> parsePartition(String partitionName, List<HudiColumnHandle> partitionColumns, List<Type> partitionColumnTypes) {
        List partitionColumnNames = partitionColumns.stream().map(HudiColumnHandle::getName).collect(Collectors.toList());
        List partitionValues = MetastoreUtil.extractPartitionValues((String)partitionName, Optional.of(partitionColumnNames));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < partitionColumns.size(); ++i) {
            HudiColumnHandle column = partitionColumns.get(i);
            NullableValue parsedValue = HiveUtil.parsePartitionValue((String)partitionName, (String)((String)partitionValues.get(i)), (Type)partitionColumnTypes.get(i), (ZoneId)ZoneId.of(TimeZone.getDefault().getID()));
            builder.put((Object)column, (Object)parsedValue);
        }
        return builder.build();
    }
}

