/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hudi.HudiConnectorFactory;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;

public class HudiPlugin
implements Plugin {
    private final String name;
    private final Optional<ExtendedHiveMetastore> metastore;

    public HudiPlugin() {
        this("hudi", Optional.empty());
    }

    public HudiPlugin(String name, Optional<ExtendedHiveMetastore> metastore) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
    }

    public Iterable<ConnectorFactory> getConnectorFactories() {
        return ImmutableList.of((Object)new HudiConnectorFactory(this.name, HudiPlugin.getClassLoader(), this.metastore));
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = HudiPlugin.class.getClassLoader();
        }
        return classLoader;
    }
}

