/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hudi.HudiConfig;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import javax.inject.Inject;

public class HudiSessionProperties {
    private final List<PropertyMetadata<?>> sessionProperties;
    private static final String HUDI_METADATA_TABLE_ENABLED = "hudi_metadata_table_enabled";
    private static final String SIZE_BASED_SPLIT_WEIGHTS_ENABLED = "size_based_split_weights_enabled";
    private static final String STANDARD_SPLIT_WEIGHT_SIZE = "standard_split_weight_size";
    private static final String MINIMUM_ASSIGNED_SPLIT_WEIGHT = "minimum_assigned_split_weight";
    private static final String MAX_OUTSTANDING_SPLITS = "max_outstanding_splits";
    private static final String SPLIT_GENERATOR_PARALLELISM = "split_generator_parallelism";

    @Inject
    public HudiSessionProperties(HudiConfig hudiConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)HUDI_METADATA_TABLE_ENABLED, (String)"Enable Hudi MetaTable Table", (Boolean)hudiConfig.isMetadataTableEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)"cache_enabled", (String)"Enable cache for hive", (Boolean)false, (boolean)true), (Object)PropertyMetadata.booleanProperty((String)SIZE_BASED_SPLIT_WEIGHTS_ENABLED, (String)String.format("If enabled, size-based splitting ensures that each batch of splits has enough data to process as defined by %s", STANDARD_SPLIT_WEIGHT_SIZE), (Boolean)hudiConfig.isSizeBasedSplitWeightsEnabled(), (boolean)false), (Object)PropertyMetadata.dataSizeProperty((String)STANDARD_SPLIT_WEIGHT_SIZE, (String)"The split size corresponding to the standard weight (1.0) when size-based split weights are enabled", (DataSize)hudiConfig.getStandardSplitWeightSize(), (boolean)false), (Object)new PropertyMetadata(MINIMUM_ASSIGNED_SPLIT_WEIGHT, "Minimum assigned split weight when size-based split weights are enabled", (Type)DoubleType.DOUBLE, Double.class, (Object)hudiConfig.getMinimumAssignedSplitWeight(), false, value -> {
            double doubleValue = ((Number)value).doubleValue();
            if (!Double.isFinite(doubleValue) || doubleValue <= 0.0 || doubleValue > 1.0) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be > 0 and <= 1.0: %s", MINIMUM_ASSIGNED_SPLIT_WEIGHT, value));
            }
            return doubleValue;
        }, value -> value), (Object)PropertyMetadata.integerProperty((String)MAX_OUTSTANDING_SPLITS, (String)"Maximum outstanding splits per batch for query", (Integer)hudiConfig.getMaxOutstandingSplits(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)SPLIT_GENERATOR_PARALLELISM, (String)"Number of threads used to generate splits from partitions", (Integer)hudiConfig.getSplitGeneratorParallelism(), (boolean)false));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isHudiMetadataTableEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(HUDI_METADATA_TABLE_ENABLED, Boolean.class);
    }

    public static boolean isSizeBasedSplitWeightsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(SIZE_BASED_SPLIT_WEIGHTS_ENABLED, Boolean.class);
    }

    public static DataSize getStandardSplitWeightSize(ConnectorSession session) {
        return (DataSize)session.getProperty(STANDARD_SPLIT_WEIGHT_SIZE, DataSize.class);
    }

    public static double getMinimumAssignedSplitWeight(ConnectorSession session) {
        return (Double)session.getProperty(MINIMUM_ASSIGNED_SPLIT_WEIGHT, Double.class);
    }

    public static int getMaxOutstandingSplits(ConnectorSession session) {
        return (Integer)session.getProperty(MAX_OUTSTANDING_SPLITS, Integer.class);
    }

    public static int getSplitGeneratorParallelism(ConnectorSession session) {
        return (Integer)session.getProperty(SPLIT_GENERATOR_PARALLELISM, Integer.class);
    }
}

