/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.presto.hudi.HudiFile;
import com.facebook.presto.hudi.HudiPartition;
import com.facebook.presto.hudi.HudiTableHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.facebook.presto.spi.SplitWeight;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class HudiSplit
implements ConnectorSplit {
    private final HudiTableHandle table;
    private final String instantTime;
    private final HudiPartition partition;
    private final Optional<HudiFile> baseFile;
    private final List<HudiFile> logFiles;
    private final List<HostAddress> addresses;
    private final NodeSelectionStrategy nodeSelectionStrategy;
    private final SplitWeight splitWeight;

    @JsonCreator
    public HudiSplit(@JsonProperty(value="table") HudiTableHandle table, @JsonProperty(value="instantTime") String instantTime, @JsonProperty(value="partition") HudiPartition partition, @JsonProperty(value="baseFile") Optional<HudiFile> baseFile, @JsonProperty(value="logFiles") List<HudiFile> logFiles, @JsonProperty(value="addresses") List<HostAddress> addresses, @JsonProperty(value="nodeSelectionStrategy") NodeSelectionStrategy nodeSelectionStrategy, @JsonProperty(value="splitWeight") SplitWeight splitWeight) {
        this.table = Objects.requireNonNull(table, "table is null");
        this.instantTime = Objects.requireNonNull(instantTime, "instantTime is null");
        this.partition = Objects.requireNonNull(partition, "partition is null");
        this.baseFile = Objects.requireNonNull(baseFile, "baseFile is null");
        this.logFiles = Objects.requireNonNull(logFiles, "logFiles is null");
        this.addresses = Objects.requireNonNull(addresses, "addresses is null");
        this.nodeSelectionStrategy = Objects.requireNonNull(nodeSelectionStrategy, "nodeSelectionStrategy is null");
        this.splitWeight = Objects.requireNonNull(splitWeight, "splitWeight is null");
    }

    @JsonProperty
    public HudiTableHandle getTable() {
        return this.table;
    }

    @JsonProperty
    public String getInstantTime() {
        return this.instantTime;
    }

    @JsonProperty
    public HudiPartition getPartition() {
        return this.partition;
    }

    @JsonProperty
    public Optional<HudiFile> getBaseFile() {
        return this.baseFile;
    }

    @JsonProperty
    public List<HudiFile> getLogFiles() {
        return this.logFiles;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return this.nodeSelectionStrategy;
    }

    public List<HostAddress> getPreferredNodes(NodeProvider nodeProvider) {
        if (this.getNodeSelectionStrategy() == NodeSelectionStrategy.SOFT_AFFINITY) {
            return this.baseFile.map(file -> nodeProvider.get(file.getPath(), 2)).orElse(this.addresses);
        }
        return this.addresses;
    }

    public Object getInfo() {
        return this;
    }

    public Object getSplitIdentifier() {
        return this;
    }

    public OptionalLong getSplitSizeInBytes() {
        return OptionalLong.empty();
    }

    @JsonProperty
    public SplitWeight getSplitWeight() {
        return this.splitWeight;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("baseFile", this.baseFile).add("logFiles", this.logFiles).toString();
    }
}

