/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.util.AsyncQueue;
import com.facebook.presto.hudi.HudiTableLayoutHandle;
import com.facebook.presto.hudi.split.HudiBackgroundSplitLoader;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;

public class HudiSplitSource
implements ConnectorSplitSource {
    private final AsyncQueue<ConnectorSplit> queue;
    private final HudiBackgroundSplitLoader splitLoader;
    private final ScheduledFuture splitLoaderFuture;

    public HudiSplitSource(ConnectorSession session, ExtendedHiveMetastore metastore, HudiTableLayoutHandle layout, HoodieTableFileSystemView fsView, List<String> partitions, String latestInstant, ExecutorService asyncQueueExecutor, ScheduledExecutorService splitLoaderExecutorService, ExecutorService splitGeneratorExecutorService, int maxOutstandingSplits) {
        this.queue = new AsyncQueue(maxOutstandingSplits, (Executor)asyncQueueExecutor);
        this.splitLoader = new HudiBackgroundSplitLoader(session, metastore, splitGeneratorExecutorService, layout, fsView, this.queue, partitions, latestInstant);
        this.splitLoaderFuture = splitLoaderExecutorService.schedule(this.splitLoader, 0L, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
        boolean noMoreSplits = this.isFinished();
        return MoreFutures.toCompletableFuture((ListenableFuture)Futures.transform((ListenableFuture)this.queue.getBatchAsync(maxSize), splits -> new ConnectorSplitSource.ConnectorSplitBatch(splits, noMoreSplits), (Executor)MoreExecutors.directExecutor()));
    }

    public void close() {
        this.queue.finish();
    }

    public boolean isFinished() {
        return this.splitLoaderFuture.isDone() && this.queue.isFinished();
    }
}

