/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.i18n.functions;

import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.google.myanmartools.TransliterateZ2U;
import com.google.myanmartools.ZawgyiDetector;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public final class I18nMyanmarFunctions {
    private static final double ZAWGYI_PROBABILITY_THRESHOLD = 0.9;
    private static final ZawgyiDetector detector = new ZawgyiDetector();
    private static final TransliterateZ2U z2uTransliterator = new TransliterateZ2U("Zawgyi to Unicode");

    private I18nMyanmarFunctions() {
    }

    @Description(value="labels whether input strings use Unicode or Zawgyi font encoding")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice myanmarFontEncoding(@SqlType(value="varchar") Slice slice) {
        if (detector.getZawgyiProbability(slice.toStringUtf8()) > 0.9) {
            return Slices.utf8Slice((String)"zawgyi");
        }
        return Slices.utf8Slice((String)"unicode");
    }

    @Description(value="transforms strings using Myanmar characters to a normalized Unicode form")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice myanmarNormalizeUnicode(@SqlType(value="varchar") Slice slice) {
        String[] rawInputPieces = slice.toStringUtf8().split("\n");
        CharSequence[] normalizedPieces = new String[rawInputPieces.length];
        for (int i = 0; i < rawInputPieces.length; ++i) {
            normalizedPieces[i] = detector.getZawgyiProbability(rawInputPieces[i]) > 0.9 ? z2uTransliterator.convert((CharSequence)rawInputPieces[i]) : rawInputPieces[i];
        }
        return Slices.utf8Slice((String)String.join((CharSequence)"\n", normalizedPieces));
    }
}

