/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.facebook.presto.hive.$internal.com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.MaterializedViewDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMaterializedViewsRegistry;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.plan.api.StageType;

public class MaterializedViewTask
extends Task<MaterializedViewDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public int execute(DriverContext driverContext) {
        if (driverContext.getCtx().getExplainAnalyze() == ExplainConfiguration.AnalyzeState.RUNNING) {
            return 0;
        }
        try {
            if (((MaterializedViewDesc)this.getWork()).isRetrieveAndInclude()) {
                Hive db = Hive.get(this.conf);
                Table mvTable = db.getTable(((MaterializedViewDesc)this.getWork()).getViewName());
                HiveMaterializedViewsRegistry.get().createMaterializedView(db.getConf(), mvTable);
            } else if (((MaterializedViewDesc)this.getWork()).isDisableRewrite()) {
                String[] names = ((MaterializedViewDesc)this.getWork()).getViewName().split("\\.");
                HiveMaterializedViewsRegistry.get().dropMaterializedView(names[0], names[1]);
            } else if (((MaterializedViewDesc)this.getWork()).isUpdateCreationMetadata()) {
                Hive db = Hive.get(this.conf);
                Table mvTable = db.getTable(((MaterializedViewDesc)this.getWork()).getViewName());
                CreationMetadata cm = new CreationMetadata(MetaStoreUtils.getDefaultCatalog(this.conf), mvTable.getDbName(), mvTable.getTableName(), ImmutableSet.copyOf(mvTable.getCreationMetadata().getTablesUsed()));
                cm.setValidTxnList(this.conf.get("hive.txn.tables.valid.writeids"));
                db.updateCreationMetadata(mvTable.getDbName(), mvTable.getTableName(), cm);
            }
        }
        catch (HiveException e) {
            LOG.debug("Exception during materialized view cache update", e);
        }
        return 0;
    }

    @Override
    public StageType getType() {
        return StageType.DDL;
    }

    @Override
    public String getName() {
        return MaterializedViewTask.class.getSimpleName();
    }
}

