/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskResult;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.session.SessionState;

public class TaskRunner
extends Thread {
    protected Task<? extends Serializable> tsk;
    protected TaskResult result;
    protected SessionState ss;
    private static AtomicLong taskCounter = new AtomicLong(0L);
    private static ThreadLocal<Long> taskRunnerID = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return taskCounter.incrementAndGet();
        }
    };
    protected Thread runner;
    private static final transient Logger LOG = LoggerFactory.getLogger(TaskRunner.class);

    public TaskRunner(Task<? extends Serializable> tsk) {
        this.tsk = tsk;
        this.result = new TaskResult();
        this.ss = SessionState.get();
    }

    public Task<? extends Serializable> getTask() {
        return this.tsk;
    }

    public TaskResult getTaskResult() {
        return this.result;
    }

    public Thread getRunner() {
        return this.runner;
    }

    public boolean isRunning() {
        return this.result.isRunning();
    }

    @Override
    public void run() {
        this.runner = Thread.currentThread();
        try {
            SessionState.start(this.ss);
            this.runSequential();
        }
        finally {
            try {
                Hive.closeCurrent();
            }
            catch (Exception e) {
                LOG.warn("Exception closing Metastore connection:" + e.getMessage());
            }
            this.runner = null;
            this.result.setRunning(false);
        }
    }

    public void runSequential() {
        int exitVal = -101;
        try {
            exitVal = this.tsk.executeTask(this.ss == null ? null : this.ss.getHiveHistory());
        }
        catch (Throwable t) {
            if (this.tsk.getException() == null) {
                this.tsk.setException(t);
            }
            LOG.error("Error in executeTask", t);
        }
        this.result.setExitVal(exitVal);
        if (this.tsk.getException() != null) {
            this.result.setTaskError(this.tsk.getException());
        }
    }

    public static long getTaskRunnerID() {
        return taskRunnerID.get();
    }
}

