/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status.impl;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.spark.SparkUtilities;
import org.apache.hadoop.hive.ql.exec.spark.Statistic.SparkStatistics;
import org.apache.hadoop.hive.ql.exec.spark.Statistic.SparkStatisticsBuilder;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobStatus;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStageProgress;
import org.apache.hadoop.hive.ql.exec.spark.status.impl.SparkMetricsUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hive.spark.client.Job;
import org.apache.hive.spark.client.JobContext;
import org.apache.hive.spark.client.JobHandle;
import org.apache.hive.spark.client.MetricsCollection;
import org.apache.hive.spark.client.SparkClient;
import org.apache.hive.spark.counter.SparkCounters;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.SparkJobInfo;
import org.apache.spark.SparkStageInfo;
import org.apache.spark.api.java.JavaFutureAction;

public class RemoteSparkJobStatus
implements SparkJobStatus {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteSparkJobStatus.class.getName());
    private final SparkClient sparkClient;
    private final JobHandle<Serializable> jobHandle;
    private Throwable error;
    private final transient long sparkClientTimeoutInSeconds;

    public RemoteSparkJobStatus(SparkClient sparkClient, JobHandle<Serializable> jobHandle, long timeoutInSeconds) {
        this.sparkClient = sparkClient;
        this.jobHandle = jobHandle;
        this.error = null;
        this.sparkClientTimeoutInSeconds = timeoutInSeconds;
    }

    @Override
    public String getAppID() {
        Future getAppID = this.sparkClient.run((Job)new GetAppIDJob());
        try {
            return (String)getAppID.get(this.sparkClientTimeoutInSeconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.warn("Failed to get APP ID.", e);
            if (Thread.interrupted()) {
                this.error = e;
            }
            return null;
        }
    }

    @Override
    public int getJobId() {
        return this.jobHandle.getSparkJobIds().size() == 1 ? (Integer)this.jobHandle.getSparkJobIds().get(0) : -1;
    }

    @Override
    public JobExecutionStatus getState() throws HiveException {
        SparkJobInfo sparkJobInfo = this.getSparkJobInfo();
        return sparkJobInfo != null ? sparkJobInfo.status() : null;
    }

    @Override
    public int[] getStageIds() throws HiveException {
        SparkJobInfo sparkJobInfo = this.getSparkJobInfo();
        return sparkJobInfo != null ? sparkJobInfo.stageIds() : new int[]{};
    }

    @Override
    public Map<String, SparkStageProgress> getSparkStageProgress() throws HiveException {
        HashMap<String, SparkStageProgress> stageProgresses = new HashMap<String, SparkStageProgress>();
        for (int stageId : this.getStageIds()) {
            SparkStageInfo sparkStageInfo = this.getSparkStageInfo(stageId);
            if (sparkStageInfo == null || sparkStageInfo.name() == null) continue;
            int runningTaskCount = sparkStageInfo.numActiveTasks();
            int completedTaskCount = sparkStageInfo.numCompletedTasks();
            int failedTaskCount = sparkStageInfo.numFailedTasks();
            int totalTaskCount = sparkStageInfo.numTasks();
            SparkStageProgress sparkStageProgress = new SparkStageProgress(totalTaskCount, completedTaskCount, runningTaskCount, failedTaskCount);
            stageProgresses.put(String.valueOf(sparkStageInfo.stageId()) + "_" + sparkStageInfo.currentAttemptId(), sparkStageProgress);
        }
        return stageProgresses;
    }

    @Override
    public SparkCounters getCounter() {
        return this.jobHandle.getSparkCounters();
    }

    @Override
    public SparkStatistics getSparkStatistics() {
        MetricsCollection metricsCollection = this.jobHandle.getMetrics();
        if (metricsCollection == null || this.getCounter() == null) {
            return null;
        }
        SparkStatisticsBuilder sparkStatisticsBuilder = new SparkStatisticsBuilder();
        sparkStatisticsBuilder.add(this.getCounter());
        Map<String, Long> flatJobMetric = SparkMetricsUtils.collectMetrics(metricsCollection.getAllMetrics());
        for (Map.Entry<String, Long> entry : flatJobMetric.entrySet()) {
            sparkStatisticsBuilder.add("SPARK", entry.getKey(), Long.toString(entry.getValue()));
        }
        return sparkStatisticsBuilder.build();
    }

    @Override
    public String getWebUIURL() {
        Future getWebUIURL = this.sparkClient.run((Job)new GetWebUIURLJob());
        try {
            return (String)getWebUIURL.get(this.sparkClientTimeoutInSeconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.warn("Failed to get web UI URL.", e);
            if (Thread.interrupted()) {
                this.error = e;
            }
            return "UNKNOWN";
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public Throwable getError() {
        if (this.error != null) {
            return this.error;
        }
        return this.jobHandle.getError();
    }

    @Override
    public void setError(Throwable e) {
        this.error = e;
    }

    public boolean isRemoteActive() {
        return this.sparkClient.isActive();
    }

    private SparkJobInfo getSparkJobInfo() throws HiveException {
        Integer sparkJobId;
        Integer n = sparkJobId = this.jobHandle.getSparkJobIds().size() == 1 ? (Integer)this.jobHandle.getSparkJobIds().get(0) : null;
        if (sparkJobId == null) {
            return null;
        }
        Future getJobInfo = this.sparkClient.run((Job)new GetJobInfoJob(this.jobHandle.getClientJobId(), sparkJobId));
        try {
            return (SparkJobInfo)getJobInfo.get(this.sparkClientTimeoutInSeconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.warn("Failed to get job info.", e);
            throw new HiveException((Throwable)e, ErrorMsg.SPARK_GET_JOB_INFO_TIMEOUT, Long.toString(this.sparkClientTimeoutInSeconds));
        }
    }

    private SparkStageInfo getSparkStageInfo(int stageId) {
        Future getStageInfo = this.sparkClient.run((Job)new GetStageInfoJob(stageId));
        try {
            return (SparkStageInfo)getStageInfo.get(this.sparkClientTimeoutInSeconds, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            LOG.warn("Error getting stage info", t);
            return null;
        }
    }

    public JobHandle.State getRemoteJobState() {
        if (this.error != null) {
            return JobHandle.State.FAILED;
        }
        return this.jobHandle.getState();
    }

    private static SparkJobInfo getDefaultJobInfo(final Integer jobId, final JobExecutionStatus status) {
        return new SparkJobInfo(){

            public int jobId() {
                return jobId == null ? -1 : jobId;
            }

            public int[] stageIds() {
                return new int[0];
            }

            public JobExecutionStatus status() {
                return status;
            }
        };
    }

    private static class GetWebUIURLJob
    implements Job<String> {
        public String call(JobContext jc) throws Exception {
            if (jc.sc().sc().uiWebUrl().isDefined()) {
                return SparkUtilities.reverseDNSLookupURL((String)jc.sc().sc().uiWebUrl().get());
            }
            return "UNDEFINED";
        }
    }

    private static class GetAppIDJob
    implements Job<String> {
        public String call(JobContext jc) throws Exception {
            return jc.sc().sc().applicationId();
        }
    }

    private static class GetStageInfoJob
    implements Job<SparkStageInfo> {
        private final int stageId;

        private GetStageInfoJob() {
            this(-1);
        }

        GetStageInfoJob(int stageId) {
            this.stageId = stageId;
        }

        public SparkStageInfo call(JobContext jc) throws Exception {
            return jc.sc().statusTracker().getStageInfo(this.stageId);
        }
    }

    private static class GetJobInfoJob
    implements Job<SparkJobInfo> {
        private final String clientJobId;
        private final int sparkJobId;

        private GetJobInfoJob() {
            this(null, -1);
        }

        GetJobInfoJob(String clientJobId, int sparkJobId) {
            this.clientJobId = clientJobId;
            this.sparkJobId = sparkJobId;
        }

        public SparkJobInfo call(JobContext jc) throws Exception {
            JavaFutureAction futureAction;
            List list;
            SparkJobInfo jobInfo = jc.sc().statusTracker().getJobInfo(this.sparkJobId);
            if (jobInfo == null && (list = (List)jc.getMonitoredJobs().get(this.clientJobId)) != null && list.size() == 1 && (futureAction = (JavaFutureAction)list.get(0)).isDone()) {
                boolean futureSucceed = true;
                try {
                    futureAction.get();
                }
                catch (Exception e) {
                    LOG.error("Failed to run job " + this.sparkJobId, e);
                    futureSucceed = false;
                }
                jobInfo = RemoteSparkJobStatus.getDefaultJobInfo(this.sparkJobId, futureSucceed ? JobExecutionStatus.SUCCEEDED : JobExecutionStatus.FAILED);
            }
            if (jobInfo == null) {
                jobInfo = RemoteSparkJobStatus.getDefaultJobInfo(this.sparkJobId, JobExecutionStatus.UNKNOWN);
            }
            return jobInfo;
        }
    }
}

