/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.facebook.presto.hive.$internal.org.codehaus.jackson.annotate.JsonProperty;
import com.facebook.presto.hive.$internal.org.codehaus.jackson.map.annotate.JsonSerialize;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import org.apache.hadoop.hive.ql.exec.tez.WmTezSession;
import org.apache.hadoop.hive.ql.wm.WmContext;

@JsonSerialize
public class WmEvent {
    private static final Logger LOG = LoggerFactory.getLogger(WmEvent.class);
    @JsonProperty(value="wmTezSessionInfo")
    private WmTezSessionInfo wmTezSessionInfo;
    @JsonProperty(value="eventStartTimestamp")
    private long eventStartTimestamp;
    @JsonProperty(value="eventEndTimestamp")
    private long eventEndTimestamp;
    @JsonProperty(value="eventType")
    private final EventType eventType;
    @JsonProperty(value="elapsedTime")
    private long elapsedTime;

    WmEvent(EventType eventType) {
        this.eventType = eventType;
        this.eventStartTimestamp = System.currentTimeMillis();
    }

    public long getEventStartTimestamp() {
        return this.eventStartTimestamp;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public WmTezSessionInfo getWmTezSessionInfo() {
        return this.wmTezSessionInfo;
    }

    public long getEventEndTimestamp() {
        return this.eventEndTimestamp;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void endEvent(WmTezSession sessionState) {
        this.wmTezSessionInfo = new WmTezSessionInfo(sessionState);
        this.eventEndTimestamp = System.currentTimeMillis();
        this.elapsedTime = this.eventEndTimestamp - this.eventStartTimestamp;
        WmContext wmContext = sessionState.getWmContext();
        if (wmContext != null) {
            wmContext.addWMEvent(this);
            LOG.info("Added WMEvent: {}", (Object)this);
        }
    }

    public String toString() {
        return "EventType: " + (Object)((Object)this.eventType) + " EventStartTimestamp: " + this.eventStartTimestamp + " elapsedTime: " + this.elapsedTime + " wmTezSessionInfo:" + this.wmTezSessionInfo;
    }

    @JsonSerialize
    public static class WmTezSessionInfo {
        @JsonProperty(value="sessionId")
        private final String sessionId;
        @JsonProperty(value="poolName")
        private final String poolName;
        @JsonProperty(value="clusterPercent")
        private final double clusterPercent;

        WmTezSessionInfo(WmTezSession wmTezSession) {
            this.poolName = wmTezSession.getPoolName();
            this.sessionId = wmTezSession.getSessionId();
            this.clusterPercent = wmTezSession.hasClusterFraction() ? wmTezSession.getClusterFraction() * 100.0 : 0.0;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public double getClusterPercent() {
            return this.clusterPercent;
        }

        public String toString() {
            return "SessionId: " + this.sessionId + " Pool: " + this.poolName + " Cluster %: " + this.clusterPercent;
        }
    }

    static enum EventType {
        GET,
        UPDATE,
        KILL,
        DESTROY,
        RESTART,
        RETURN,
        MOVE;

    }
}

