/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.facebook.presto.hive.$internal.com.google.common.collect.ImmutableList;
import com.facebook.presto.hive.$internal.com.google.common.collect.ImmutableMap;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnion;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveReduceExpressionsRule;

public class HiveUnionPullUpConstantsRule
extends RelOptRule {
    protected static final Logger LOG = LoggerFactory.getLogger(HiveUnionPullUpConstantsRule.class);
    public static final HiveUnionPullUpConstantsRule INSTANCE = new HiveUnionPullUpConstantsRule(HiveUnion.class, HiveRelFactories.HIVE_BUILDER);

    private HiveUnionPullUpConstantsRule(Class<? extends Union> unionClass, RelBuilderFactory relBuilderFactory) {
        super(HiveUnionPullUpConstantsRule.operand(unionClass, (RelOptRuleOperandChildren)HiveUnionPullUpConstantsRule.any()), relBuilderFactory, null);
    }

    public void onMatch(RelOptRuleCall call) {
        Union union = (Union)call.rel(0);
        int count = union.getRowType().getFieldCount();
        if (count == 1) {
            return;
        }
        RexBuilder rexBuilder = union.getCluster().getRexBuilder();
        RelMetadataQuery mq = call.getMetadataQuery();
        RelOptPredicateList predicates = mq.getPulledUpPredicates((RelNode)union);
        if (predicates == null) {
            return;
        }
        ImmutableMap conditionsExtracted = HiveReduceExpressionsRule.predicateConstants(RexNode.class, (RexBuilder)rexBuilder, (RelOptPredicateList)predicates);
        HashMap constants = new HashMap();
        for (int i = 0; i < count; ++i) {
            RexInputRef expr = rexBuilder.makeInputRef((RelNode)union, i);
            if (!conditionsExtracted.containsKey(expr)) continue;
            constants.put(expr, conditionsExtracted.get(expr));
        }
        if (constants.isEmpty()) {
            return;
        }
        List fields = union.getRowType().getFieldList();
        AbstractCollection topChildExprs = new ArrayList<Object>();
        ArrayList<String> topChildExprsFields = new ArrayList<String>();
        ArrayList<RexInputRef> refs = new ArrayList<RexInputRef>();
        ImmutableBitSet.Builder refsIndexBuilder = ImmutableBitSet.builder();
        for (int i = 0; i < count; ++i) {
            RexInputRef expr = rexBuilder.makeInputRef((RelNode)union, i);
            RelDataTypeField field = (RelDataTypeField)fields.get(i);
            if (constants.containsKey(expr)) {
                topChildExprs.add(constants.get(expr));
                topChildExprsFields.add(field.getName());
                continue;
            }
            topChildExprs.add(expr);
            topChildExprsFields.add(field.getName());
            refs.add(expr);
            refsIndexBuilder.set(i);
        }
        ImmutableBitSet refsIndex = refsIndexBuilder.build();
        Mapping mapping = RelOptUtil.permutation(refs, (RelDataType)union.getInput(0).getRowType()).inverse();
        topChildExprs = ImmutableList.copyOf(RexUtil.apply((Mappings.TargetMapping)mapping, topChildExprs));
        RelBuilder relBuilder = call.builder();
        for (int i = 0; i < union.getInputs().size(); ++i) {
            RelNode input = union.getInput(i);
            ArrayList<Pair> newChildExprs = new ArrayList<Pair>();
            for (int j = 0; j < refsIndex.cardinality(); ++j) {
                int pos = refsIndex.nth(j);
                newChildExprs.add(Pair.of((Object)rexBuilder.makeInputRef(input, pos), (Object)((RelDataTypeField)input.getRowType().getFieldList().get(pos)).getName()));
            }
            if (newChildExprs.isEmpty()) {
                newChildExprs.add(Pair.of(topChildExprs.get(0), topChildExprsFields.get(0)));
            }
            relBuilder.push(input);
            relBuilder.project((Iterable)Pair.left(newChildExprs), (Iterable)Pair.right(newChildExprs));
        }
        relBuilder.union(union.all, union.getInputs().size());
        relBuilder.project(topChildExprs, topChildExprsFields);
        relBuilder.convert(union.getRowType(), false);
        call.transformTo(relBuilder.build());
    }
}

