/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class MaterializedViewRebuildSemanticAnalyzer
extends CalcitePlanner {
    private static final Logger LOG = LoggerFactory.getLogger(MaterializedViewRebuildSemanticAnalyzer.class);

    public MaterializedViewRebuildSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        ASTNode rewrittenAST;
        String dbDotTable;
        String[] qualifiedTableName;
        block8: {
            if (this.mvRebuildMode != SemanticAnalyzer.MaterializationRebuildMode.NONE) {
                super.analyzeInternal(ast);
                return;
            }
            qualifiedTableName = MaterializedViewRebuildSemanticAnalyzer.getQualifiedTableName((ASTNode)ast.getChild(0));
            dbDotTable = MaterializedViewRebuildSemanticAnalyzer.getDotName(qualifiedTableName);
            try {
                LockState state;
                Table tab = this.getTableObjectByName(dbDotTable, true);
                if (!tab.isMaterializedView()) {
                    throw new SemanticException(ErrorMsg.REBUILD_NO_MATERIALIZED_VIEW, new String[0]);
                }
                String viewText = tab.getViewExpandedText();
                if (viewText.trim().isEmpty()) {
                    throw new SemanticException(ErrorMsg.MATERIALIZED_VIEW_DEF_EMPTY, new String[0]);
                }
                Context ctx = new Context(this.queryState.getConf());
                rewrittenAST = ParseUtils.parse("insert overwrite table `" + qualifiedTableName[0] + "`.`" + qualifiedTableName[1] + "` " + viewText, ctx);
                this.ctx.addRewrittenStatementContext(ctx);
                if (this.ctx.isExplainPlan() || !AcidUtils.isTransactionalTable(tab)) break block8;
                HiveTxnManager txnManager = this.getTxnMgr();
                try {
                    state = txnManager.acquireMaterializationRebuildLock(qualifiedTableName[0], qualifiedTableName[1], txnManager.getCurrentTxnId()).getState();
                }
                catch (LockException e) {
                    throw new SemanticException("Exception acquiring lock for rebuilding the materialized view", e);
                }
                if (state != LockState.ACQUIRED) {
                    throw new SemanticException("Another process is rebuilding the materialized view " + dbDotTable);
                }
            }
            catch (Exception e) {
                throw new SemanticException(e);
            }
        }
        this.mvRebuildMode = SemanticAnalyzer.MaterializationRebuildMode.INSERT_OVERWRITE_REBUILD;
        this.mvRebuildDbName = qualifiedTableName[0];
        this.mvRebuildName = qualifiedTableName[1];
        LOG.debug("Rebuilding materialized view " + dbDotTable);
        super.analyzeInternal(rewrittenAST);
    }
}

