/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.Serializable;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Export Work", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ExportWork
implements Serializable {
    private Logger LOG = LoggerFactory.getLogger(ExportWork.class);
    private static final long serialVersionUID = 1L;
    private final String exportRootDirName;
    private BaseSemanticAnalyzer.TableSpec tableSpec;
    private ReplicationSpec replicationSpec;
    private String astRepresentationForErrorMsg;
    private String qualifiedTableName;

    public ExportWork(String exportRootDirName, BaseSemanticAnalyzer.TableSpec tableSpec, ReplicationSpec replicationSpec, String astRepresentationForErrorMsg, String qualifiedTable) {
        this.exportRootDirName = exportRootDirName;
        this.tableSpec = tableSpec;
        this.replicationSpec = replicationSpec;
        this.astRepresentationForErrorMsg = astRepresentationForErrorMsg;
        this.qualifiedTableName = qualifiedTable;
    }

    public String getExportRootDir() {
        return this.exportRootDirName;
    }

    public BaseSemanticAnalyzer.TableSpec getTableSpec() {
        return this.tableSpec;
    }

    public void setTableSpec(BaseSemanticAnalyzer.TableSpec tableSpec) {
        this.tableSpec = tableSpec;
    }

    public ReplicationSpec getReplicationSpec() {
        return this.replicationSpec;
    }

    public void setReplicationSpec(ReplicationSpec replicationSpec) {
        this.replicationSpec = replicationSpec;
    }

    public String getAstRepresentationForErrorMsg() {
        return this.astRepresentationForErrorMsg;
    }

    public void setAstRepresentationForErrorMsg(String astRepresentationForErrorMsg) {
        this.astRepresentationForErrorMsg = astRepresentationForErrorMsg;
    }

    public void acidPostProcess(Hive db) throws HiveException {
        if (this.qualifiedTableName != null) {
            this.LOG.info("Swapping export of " + this.tableSpec.tableName + " to " + this.qualifiedTableName + " using partSpec=" + this.tableSpec.partSpec);
            this.tableSpec = new BaseSemanticAnalyzer.TableSpec(db, this.qualifiedTableName, this.tableSpec.partSpec, true);
        }
    }
}

