/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import com.facebook.presto.hive.$internal.com.google.common.base.Function;
import com.facebook.presto.hive.$internal.com.google.common.collect.ImmutableCollection;
import com.facebook.presto.hive.$internal.com.google.common.collect.ImmutableListMultimap;
import com.facebook.presto.hive.$internal.com.google.common.collect.Lists;
import com.facebook.presto.hive.$internal.com.google.common.collect.Multimaps;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.StatsTask;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.StatsProvidingRecordReader;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.BasicStatsNoJobWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.IStatsProcessor;
import org.apache.hadoop.hive.ql.stats.Partish;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.ReflectionUtil;

public class BasicStatsNoJobTask
implements IStatsProcessor {
    private static final transient Logger LOG = LoggerFactory.getLogger(BasicStatsNoJobTask.class);
    private HiveConf conf;
    private BasicStatsNoJobWork work;
    private SessionState.LogHelper console;

    public BasicStatsNoJobTask(HiveConf conf, BasicStatsNoJobWork work) {
        this.conf = conf;
        this.work = work;
        this.console = new SessionState.LogHelper(LOG);
    }

    @Override
    public void initialize(CompilationOpContext opContext) {
    }

    @Override
    public int process(Hive db, Table tbl) throws Exception {
        LOG.info("Executing stats (no job) task");
        ExecutorService threadPool = StatsTask.newThreadPool(this.conf);
        return this.aggregateStats(threadPool, db);
    }

    public StageType getType() {
        return StageType.STATS;
    }

    public String getName() {
        return "STATS-NO-JOB";
    }

    private int aggregateStats(ExecutorService threadPool, Hive db) {
        int ret;
        block11: {
            ret = 0;
            try {
                JobConf jc = new JobConf((Configuration)this.conf);
                BaseSemanticAnalyzer.TableSpec tableSpecs = this.work.getTableSpecs();
                if (tableSpecs == null) {
                    throw new RuntimeException("this is unexpected...needs some investigation");
                }
                Table table = tableSpecs.tableHandle;
                Collection<Partition> partitions = null;
                if (this.work.getPartitions() == null || this.work.getPartitions().isEmpty()) {
                    if (table.isPartitioned()) {
                        partitions = tableSpecs.partitions;
                    }
                } else {
                    partitions = this.work.getPartitions();
                }
                LinkedList<Partish> partishes = Lists.newLinkedList();
                if (partitions == null) {
                    partishes.add(Partish.buildFor(table));
                } else {
                    for (Partition part : partitions) {
                        partishes.add(Partish.buildFor(table, part));
                    }
                }
                ArrayList<FooterStatCollector> scs = Lists.newArrayList();
                for (Partish partish : partishes) {
                    scs.add(new FooterStatCollector(jc, partish));
                }
                for (FooterStatCollector sc : scs) {
                    sc.init(this.conf, this.console);
                    threadPool.execute(sc);
                }
                LOG.debug("Stats collection waiting for threadpool to shutdown..");
                this.shutdownAndAwaitTermination(threadPool);
                LOG.debug("Stats collection threadpool shutdown successful.");
                ret = this.updatePartitions(db, scs, table);
            }
            catch (Exception e) {
                this.console.printError("Failed to collect footer statistics.", "Failed with exception " + e.getMessage() + "\n" + StringUtils.stringifyException((Throwable)e));
                if (!this.work.isStatsReliable()) break block11;
                ret = -1;
            }
        }
        return ret;
    }

    private int updatePartitions(Hive db, List<FooterStatCollector> scs, Table table) throws InvalidOperationException, HiveException {
        String tableFullName = table.getFullyQualifiedName();
        if (scs.isEmpty()) {
            return 0;
        }
        if (this.work.isStatsReliable()) {
            for (FooterStatCollector footerStatCollector : scs) {
                if (footerStatCollector.result != null) continue;
                LOG.debug("Stats requested to be reliable. Empty stats found: {}", (Object)footerStatCollector.partish.getSimpleName());
                return -1;
            }
        }
        ArrayList<FooterStatCollector> validColectors = Lists.newArrayList();
        for (FooterStatCollector statsCollection : scs) {
            if (!statsCollection.isValid()) continue;
            validColectors.add(statsCollection);
        }
        EnvironmentContext environmentContext = new EnvironmentContext();
        environmentContext.putToProperties("DO_NOT_UPDATE_STATS", "true");
        ImmutableListMultimap<String, FooterStatCollector> collectorsByTable = Multimaps.index(validColectors, FooterStatCollector.SIMPLE_NAME_FUNCTION);
        LOG.debug("Collectors.size(): {}", (Object)collectorsByTable.keySet());
        if (((AbstractCollection)((Object)collectorsByTable.keySet())).size() < 1) {
            LOG.warn("Collectors are empty! ; {}", (Object)tableFullName);
        }
        assert (((AbstractCollection)((Object)collectorsByTable.keySet())).size() <= 1);
        LOG.debug("Updating stats for: {}", (Object)tableFullName);
        for (String partName : collectorsByTable.keySet()) {
            ImmutableCollection values = collectorsByTable.get((Object)partName);
            if (values == null) {
                throw new RuntimeException("very intresting");
            }
            if (((FooterStatCollector)values.get(0)).result instanceof Table) {
                db.alterTable(tableFullName, (Table)((FooterStatCollector)values.get(0)).result, environmentContext);
                LOG.debug("Updated stats for {}.", (Object)tableFullName);
                continue;
            }
            if (((FooterStatCollector)values.get(0)).result instanceof Partition) {
                List<Partition> results = Lists.transform(values, FooterStatCollector.EXTRACT_RESULT_FUNCTION);
                db.alterPartitions(tableFullName, results, environmentContext);
                LOG.debug("Bulk updated {} partitions of {}.", (Object)results.size(), (Object)tableFullName);
                continue;
            }
            throw new RuntimeException("inconsistent");
        }
        LOG.debug("Updated stats for: {}", (Object)tableFullName);
        return 0;
    }

    private void shutdownAndAwaitTermination(ExecutorService threadPool) {
        threadPool.shutdown();
        try {
            while (!threadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                LOG.debug("Waiting for all stats tasks to finish...");
            }
            threadPool.shutdownNow();
            if (!threadPool.awaitTermination(100L, TimeUnit.SECONDS)) {
                LOG.debug("Stats collection thread pool did not terminate");
            }
        }
        catch (InterruptedException ie) {
            threadPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void setDpPartSpecs(Collection<Partition> dpPartSpecs) {
    }

    static class FooterStatCollector
    implements Runnable {
        private Partish partish;
        private Object result;
        private JobConf jc;
        private Path dir;
        private FileSystem fs;
        private SessionState.LogHelper console;
        public static final Function<FooterStatCollector, String> SIMPLE_NAME_FUNCTION = new Function<FooterStatCollector, String>(){

            @Override
            public String apply(FooterStatCollector sc) {
                return String.format("%s#%s", sc.partish.getTable().getCompleteName(), sc.partish.getPartishType());
            }
        };
        private static final Function<FooterStatCollector, Partition> EXTRACT_RESULT_FUNCTION = new Function<FooterStatCollector, Partition>(){

            @Override
            public Partition apply(FooterStatCollector input) {
                return (Partition)input.result;
            }
        };

        public FooterStatCollector(JobConf jc, Partish partish) {
            this.jc = jc;
            this.partish = partish;
        }

        private boolean isValid() {
            return this.result != null;
        }

        public void init(HiveConf conf, SessionState.LogHelper console) throws IOException {
            this.console = console;
            this.dir = new Path(this.partish.getPartSd().getLocation());
            this.fs = this.dir.getFileSystem((Configuration)conf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<String, String> parameters = this.partish.getPartParameters();
            try {
                long numRows = 0L;
                long rawDataSize = 0L;
                long fileSize = 0L;
                long numFiles = 0L;
                Utilities.FILE_OP_LOGGER.debug("Aggregating stats for {}", (Object)this.dir);
                List<FileStatus> fileList = null;
                fileList = this.partish.getTable() != null && AcidUtils.isTransactionalTable(this.partish.getTable()) ? AcidUtils.getAcidFilesForStats(this.partish.getTable(), this.dir, (Configuration)this.jc, this.fs) : HiveStatsUtils.getFileStatusRecurse(this.dir, -1, this.fs);
                for (FileStatus file : fileList) {
                    Utilities.FILE_OP_LOGGER.debug("Computing stats for {}", (Object)file);
                    if (file.isDirectory()) continue;
                    InputFormat inputFormat = ReflectionUtil.newInstance(this.partish.getInputFormatClass(), (Configuration)this.jc);
                    FileSplit dummySplit = new FileSplit(file.getPath(), 0L, 0L, new String[]{this.partish.getLocation()});
                    if (file.getLen() == 0L) {
                        ++numFiles;
                        continue;
                    }
                    try (RecordReader recordReader = inputFormat.getRecordReader((InputSplit)dummySplit, this.jc, Reporter.NULL);){
                        if (recordReader instanceof StatsProvidingRecordReader) {
                            StatsProvidingRecordReader statsRR = (StatsProvidingRecordReader)recordReader;
                            rawDataSize += statsRR.getStats().getRawDataSize();
                            numRows += statsRR.getStats().getRowCount();
                            fileSize += file.getLen();
                            ++numFiles;
                            continue;
                        }
                        throw new HiveException(String.format("Unexpected file found during reading footers for: %s ", file));
                    }
                }
                StatsSetupConst.setBasicStatsState(parameters, "true");
                parameters.put("numRows", String.valueOf(numRows));
                parameters.put("rawDataSize", String.valueOf(rawDataSize));
                parameters.put("totalSize", String.valueOf(fileSize));
                parameters.put("numFiles", String.valueOf(numFiles));
                this.result = this.partish.getPartition() != null ? new Partition(this.partish.getTable(), this.partish.getPartition().getTPartition()) : new Table(this.partish.getTable().getTTable());
                String msg = this.partish.getSimpleName() + " stats: [" + this.toString(parameters) + ']';
                LOG.debug(msg);
                this.console.printInfo(msg);
            }
            catch (Exception e) {
                this.console.printInfo("[Warning] could not update stats for " + this.partish.getSimpleName() + ".", "Failed with exception " + e.getMessage() + "\n" + StringUtils.stringifyException((Throwable)e));
            }
        }

        private String toString(Map<String, String> parameters) {
            StringBuilder builder = new StringBuilder();
            for (String statType : StatsSetupConst.supportedStats) {
                String value = parameters.get(statType);
                if (value == null) continue;
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(statType).append('=').append(value);
            }
            return builder.toString();
        }
    }

    static class StatItem {
        Partish partish;
        Map<String, String> params;
        Object result;

        StatItem() {
        }
    }
}

