/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.io;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.InvalidRecordException;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.Type;

public class GroupColumnIO
extends ColumnIO {
    private static final Logger LOG = LoggerFactory.getLogger(GroupColumnIO.class);
    private final Map<String, ColumnIO> childrenByName = new HashMap<String, ColumnIO>();
    private final List<ColumnIO> children = new ArrayList<ColumnIO>();
    private int childrenSize = 0;

    GroupColumnIO(GroupType groupType, GroupColumnIO parent, int index) {
        super(groupType, parent, index);
    }

    void add(ColumnIO child) {
        this.children.add(child);
        this.childrenByName.put(child.getType().getName(), child);
        ++this.childrenSize;
    }

    @Override
    void setLevels(int r, int d, String[] fieldPath, int[] indexFieldPath, List<ColumnIO> repetition, List<ColumnIO> path) {
        super.setLevels(r, d, fieldPath, indexFieldPath, repetition, path);
        for (ColumnIO child : this.children) {
            List<ColumnIO> newRepetition;
            String[] newFieldPath = Arrays.copyOf(fieldPath, fieldPath.length + 1);
            int[] newIndexFieldPath = Arrays.copyOf(indexFieldPath, indexFieldPath.length + 1);
            newFieldPath[fieldPath.length] = child.getType().getName();
            newIndexFieldPath[indexFieldPath.length] = child.getIndex();
            if (child.getType().isRepetition(Type.Repetition.REPEATED)) {
                newRepetition = new ArrayList<ColumnIO>(repetition);
                newRepetition.add(child);
            } else {
                newRepetition = repetition;
            }
            ArrayList<ColumnIO> newPath = new ArrayList<ColumnIO>(path);
            newPath.add(child);
            child.setLevels(child.getType().isRepetition(Type.Repetition.REPEATED) ? r + 1 : r, !child.getType().isRepetition(Type.Repetition.REQUIRED) ? d + 1 : d, newFieldPath, newIndexFieldPath, newRepetition, newPath);
        }
    }

    @Override
    List<String[]> getColumnNames() {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (ColumnIO c : this.children) {
            result.addAll(c.getColumnNames());
        }
        return result;
    }

    @Override
    PrimitiveColumnIO getLast() {
        return this.children.get(this.children.size() - 1).getLast();
    }

    @Override
    PrimitiveColumnIO getFirst() {
        return this.children.get(0).getFirst();
    }

    public ColumnIO getChild(String name) {
        return this.childrenByName.get(name);
    }

    public ColumnIO getChild(int fieldIndex) {
        try {
            return this.children.get(fieldIndex);
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidRecordException("could not get child " + fieldIndex + " from " + this.children, e);
        }
    }

    public int getChildrenCount() {
        return this.childrenSize;
    }
}

