/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.iceberg.util.PageListBuilder;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class FilesTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final Table icebergTable;
    private final Optional<Long> snapshotId;

    public FilesTable(SchemaTableName tableName, Table icebergTable, Optional<Long> snapshotId, TypeManager typeManager) {
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
        this.tableMetadata = new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), (List)ImmutableList.builder().add((Object)new ColumnMetadata("file_path", (com.facebook.presto.common.type.Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("file_format", (com.facebook.presto.common.type.Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("record_count", (com.facebook.presto.common.type.Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("file_size_in_bytes", (com.facebook.presto.common.type.Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("column_sizes", typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)IntegerType.INTEGER.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)BigintType.BIGINT.getTypeSignature()))))).add((Object)new ColumnMetadata("value_counts", typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)IntegerType.INTEGER.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)BigintType.BIGINT.getTypeSignature()))))).add((Object)new ColumnMetadata("null_value_counts", typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)IntegerType.INTEGER.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)BigintType.BIGINT.getTypeSignature()))))).add((Object)new ColumnMetadata("lower_bounds", typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)IntegerType.INTEGER.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)VarcharType.VARCHAR.getTypeSignature()))))).add((Object)new ColumnMetadata("upper_bounds", typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)IntegerType.INTEGER.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)VarcharType.VARCHAR.getTypeSignature()))))).add((Object)new ColumnMetadata("key_metadata", (com.facebook.presto.common.type.Type)VarbinaryType.VARBINARY)).add((Object)new ColumnMetadata("split_offsets", (com.facebook.presto.common.type.Type)new ArrayType((com.facebook.presto.common.type.Type)BigintType.BIGINT))).build());
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        return new FixedPageSource(FilesTable.buildPages(this.tableMetadata, session, this.icebergTable, this.snapshotId));
    }

    private static List<Page> buildPages(ConnectorTableMetadata tableMetadata, ConnectorSession session, Table icebergTable, Optional<Long> snapshotId) {
        PageListBuilder pagesBuilder = PageListBuilder.forTable(tableMetadata);
        TableScan tableScan = IcebergUtil.getTableScan((TupleDomain<IcebergColumnHandle>)TupleDomain.all(), snapshotId, icebergTable).includeColumnStats();
        Map<Integer, Type> idToTypeMap = FilesTable.getIdToTypeMap(icebergTable.schema());
        tableScan.planFiles().forEach(fileScanTask -> {
            DataFile dataFile = fileScanTask.file();
            pagesBuilder.beginRow();
            pagesBuilder.appendVarchar(dataFile.path().toString());
            pagesBuilder.appendVarchar(dataFile.format().name());
            pagesBuilder.appendBigint(dataFile.recordCount());
            pagesBuilder.appendBigint(dataFile.fileSizeInBytes());
            if (FilesTable.checkNonNull(dataFile.columnSizes(), pagesBuilder)) {
                pagesBuilder.appendIntegerBigintMap(dataFile.columnSizes());
            }
            if (FilesTable.checkNonNull(dataFile.valueCounts(), pagesBuilder)) {
                pagesBuilder.appendIntegerBigintMap(dataFile.valueCounts());
            }
            if (FilesTable.checkNonNull(dataFile.nullValueCounts(), pagesBuilder)) {
                pagesBuilder.appendIntegerBigintMap(dataFile.nullValueCounts());
            }
            if (FilesTable.checkNonNull(dataFile.lowerBounds(), pagesBuilder)) {
                pagesBuilder.appendIntegerVarcharMap((Map)dataFile.lowerBounds().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> Transforms.identity((Type)((Type)idToTypeMap.get(entry.getKey()))).toHumanString(Conversions.fromByteBuffer((Type)((Type)idToTypeMap.get(entry.getKey())), (ByteBuffer)((ByteBuffer)entry.getValue()))))));
            }
            if (FilesTable.checkNonNull(dataFile.upperBounds(), pagesBuilder)) {
                pagesBuilder.appendIntegerVarcharMap((Map)dataFile.upperBounds().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> Transforms.identity((Type)((Type)idToTypeMap.get(entry.getKey()))).toHumanString(Conversions.fromByteBuffer((Type)((Type)idToTypeMap.get(entry.getKey())), (ByteBuffer)((ByteBuffer)entry.getValue()))))));
            }
            if (FilesTable.checkNonNull(dataFile.keyMetadata(), pagesBuilder)) {
                pagesBuilder.appendVarbinary(Slices.wrappedBuffer((ByteBuffer)dataFile.keyMetadata()));
            }
            if (FilesTable.checkNonNull(dataFile.splitOffsets(), pagesBuilder)) {
                pagesBuilder.appendBigintArray(dataFile.splitOffsets());
            }
            pagesBuilder.endRow();
        });
        return pagesBuilder.build();
    }

    private static Map<Integer, Type> getIdToTypeMap(Schema schema) {
        ImmutableMap.Builder idToTypeMap = ImmutableMap.builder();
        for (Types.NestedField field : schema.columns()) {
            FilesTable.populateIdToTypeMap(field, (ImmutableMap.Builder<Integer, Type>)idToTypeMap);
        }
        return idToTypeMap.build();
    }

    private static void populateIdToTypeMap(Types.NestedField field, ImmutableMap.Builder<Integer, Type> idToTypeMap) {
        Type type = field.type();
        idToTypeMap.put((Object)field.fieldId(), (Object)type);
        if (type instanceof Type.NestedType) {
            type.asNestedType().fields().forEach(child -> FilesTable.populateIdToTypeMap(child, idToTypeMap));
        }
    }

    private static boolean checkNonNull(Object object, PageListBuilder pagesBuilder) {
        if (object == null) {
            pagesBuilder.appendNull();
            return false;
        }
        return true;
    }
}

