/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.iceberg.CatalogType;
import com.facebook.presto.iceberg.CommitTaskData;
import com.facebook.presto.iceberg.IcebergConfig;
import com.facebook.presto.iceberg.IcebergHadoopMetadata;
import com.facebook.presto.iceberg.IcebergHiveMetadata;
import com.facebook.presto.iceberg.IcebergResourceFactory;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import java.util.Objects;
import javax.inject.Inject;

public class IcebergMetadataFactory {
    private final ExtendedHiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;
    private final JsonCodec<CommitTaskData> commitTaskCodec;
    private final IcebergResourceFactory resourceFactory;
    private final CatalogType catalogType;

    @Inject
    public IcebergMetadataFactory(IcebergConfig config, IcebergResourceFactory resourceFactory, ExtendedHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, TypeManager typeManager, JsonCodec<CommitTaskData> commitTaskCodec) {
        this.resourceFactory = Objects.requireNonNull(resourceFactory, "resourceFactory is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.commitTaskCodec = Objects.requireNonNull(commitTaskCodec, "commitTaskCodec is null");
        Objects.requireNonNull(config, "config is null");
        this.catalogType = config.getCatalogType();
    }

    public ConnectorMetadata create() {
        switch (this.catalogType) {
            case HADOOP: {
                return new IcebergHadoopMetadata(this.resourceFactory, this.typeManager, this.commitTaskCodec);
            }
            case HIVE: {
                return new IcebergHiveMetadata(this.metastore, this.hdfsEnvironment, this.typeManager, this.commitTaskCodec);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported Presto Iceberg catalog type " + (Object)((Object)this.catalogType));
    }
}

