/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.iceberg.CatalogType;
import com.facebook.presto.iceberg.IcebergConfig;
import com.facebook.presto.iceberg.IcebergHiveMetadata;
import com.facebook.presto.iceberg.IcebergMetadataFactory;
import com.facebook.presto.iceberg.IcebergResourceFactory;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.iceberg.util.IcebergPrestoModelConverters;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.procedure.Procedure;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.iceberg.Table;

public class RollbackToSnapshotProcedure
implements Provider<Procedure> {
    private static final MethodHandle ROLLBACK_TO_SNAPSHOT = MethodHandleUtil.methodHandle(RollbackToSnapshotProcedure.class, (String)"rollbackToSnapshot", (Class[])new Class[]{ConnectorSession.class, String.class, String.class, Long.class});
    private final IcebergMetadataFactory metadataFactory;
    private final HdfsEnvironment hdfsEnvironment;
    private final IcebergResourceFactory resourceFactory;
    private final CatalogType catalogType;

    @Inject
    public RollbackToSnapshotProcedure(IcebergConfig config, IcebergMetadataFactory metadataFactory, HdfsEnvironment hdfsEnvironment, IcebergResourceFactory resourceFactory) {
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.resourceFactory = Objects.requireNonNull(resourceFactory, "resourceFactory is null");
        Objects.requireNonNull(config, "config is null");
        this.catalogType = config.getCatalogType();
    }

    public Procedure get() {
        return new Procedure("system", "rollback_to_snapshot", (List)ImmutableList.of((Object)new Procedure.Argument("schema", "varchar"), (Object)new Procedure.Argument("table", "varchar"), (Object)new Procedure.Argument("snapshot_id", "bigint")), ROLLBACK_TO_SNAPSHOT.bindTo(this));
    }

    public void rollbackToSnapshot(ConnectorSession clientSession, String schema, String table, Long snapshotId) {
        Table icebergTable;
        SchemaTableName schemaTableName = new SchemaTableName(schema, table);
        ConnectorMetadata metadata = this.metadataFactory.create();
        if (this.catalogType == CatalogType.HADOOP) {
            icebergTable = this.resourceFactory.getCatalog(clientSession).loadTable(IcebergPrestoModelConverters.toIcebergTableIdentifier(schema, table));
        } else {
            ExtendedHiveMetastore metastore = ((IcebergHiveMetadata)metadata).getMetastore();
            icebergTable = IcebergUtil.getHiveIcebergTable(metastore, this.hdfsEnvironment, clientSession, schemaTableName);
        }
        icebergTable.rollback().toSnapshotId(snapshotId.longValue()).commit();
    }
}

