/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceInput;
import com.facebook.presto.orc.StreamId;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.StripeReader;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public class CachingStripeMetadataSource
implements StripeMetadataSource {
    private final StripeMetadataSource delegate;
    private final Cache<StripeReader.StripeId, Slice> footerSliceCache;
    private final Cache<StripeReader.StripeStreamId, Slice> stripeStreamCache;
    private final Optional<Cache<StripeReader.StripeStreamId, List<RowGroupIndex>>> rowGroupIndexCache;

    public CachingStripeMetadataSource(StripeMetadataSource delegate, Cache<StripeReader.StripeId, Slice> footerSliceCache, Cache<StripeReader.StripeStreamId, Slice> stripeStreamCache, Optional<Cache<StripeReader.StripeStreamId, List<RowGroupIndex>>> rowGroupIndexCache) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.footerSliceCache = Objects.requireNonNull(footerSliceCache, "footerSliceCache is null");
        this.stripeStreamCache = Objects.requireNonNull(stripeStreamCache, "rowIndexSliceCache is null");
        this.rowGroupIndexCache = Objects.requireNonNull(rowGroupIndexCache, "rowGroupIndexCache is null");
    }

    @Override
    public Slice getStripeFooterSlice(OrcDataSource orcDataSource, StripeReader.StripeId stripeId, long footerOffset, int footerLength, boolean cacheable) throws IOException {
        try {
            if (!cacheable) {
                return this.delegate.getStripeFooterSlice(orcDataSource, stripeId, footerOffset, footerLength, cacheable);
            }
            return (Slice)this.footerSliceCache.get((Object)stripeId, () -> this.delegate.getStripeFooterSlice(orcDataSource, stripeId, footerOffset, footerLength, cacheable));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), IOException.class);
            throw new IOException("Unexpected error in stripe footer reading after footerSliceCache miss", e.getCause());
        }
    }

    @Override
    public Map<StreamId, OrcDataSourceInput> getInputs(OrcDataSource orcDataSource, StripeReader.StripeId stripeId, Map<StreamId, DiskRange> diskRanges, boolean cacheable) throws IOException {
        if (!cacheable) {
            return this.delegate.getInputs(orcDataSource, stripeId, diskRanges, cacheable);
        }
        ImmutableMap.Builder inputsBuilder = ImmutableMap.builder();
        ImmutableMap.Builder uncachedDiskRangesBuilder = ImmutableMap.builder();
        for (Map.Entry<StreamId, DiskRange> entry : diskRanges.entrySet()) {
            if (CachingStripeMetadataSource.isCachedStream(entry.getKey().getStreamKind())) {
                Slice streamSlice = (Slice)this.stripeStreamCache.getIfPresent((Object)new StripeReader.StripeStreamId(stripeId, entry.getKey()));
                if (streamSlice != null) {
                    inputsBuilder.put((Object)entry.getKey(), (Object)new OrcDataSourceInput((FixedLengthSliceInput)new BasicSliceInput(streamSlice), streamSlice.length()));
                    continue;
                }
                uncachedDiskRangesBuilder.put(entry);
                continue;
            }
            uncachedDiskRangesBuilder.put(entry);
        }
        Map<StreamId, OrcDataSourceInput> uncachedInputs = this.delegate.getInputs(orcDataSource, stripeId, (Map<StreamId, DiskRange>)uncachedDiskRangesBuilder.build(), cacheable);
        for (Map.Entry<StreamId, OrcDataSourceInput> entry : uncachedInputs.entrySet()) {
            if (CachingStripeMetadataSource.isCachedStream(entry.getKey().getStreamKind())) {
                Slice streamSlice = Slices.wrappedBuffer((byte[])entry.getValue().getInput().readSlice(Math.toIntExact(entry.getValue().getInput().length())).getBytes());
                this.stripeStreamCache.put((Object)new StripeReader.StripeStreamId(stripeId, entry.getKey()), (Object)streamSlice);
                inputsBuilder.put((Object)entry.getKey(), (Object)new OrcDataSourceInput((FixedLengthSliceInput)new BasicSliceInput(streamSlice), Math.toIntExact(streamSlice.getRetainedSize())));
                continue;
            }
            inputsBuilder.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        return inputsBuilder.build();
    }

    @Override
    public List<RowGroupIndex> getRowIndexes(MetadataReader metadataReader, PostScript.HiveWriterVersion hiveWriterVersion, StripeReader.StripeId stripId, StreamId streamId, OrcInputStream inputStream, List<HiveBloomFilter> bloomFilters, RuntimeStats runtimeStats) throws IOException {
        List rowGroupIndices;
        if (this.rowGroupIndexCache.isPresent()) {
            rowGroupIndices = (List)this.rowGroupIndexCache.get().getIfPresent((Object)new StripeReader.StripeStreamId(stripId, streamId));
            if (rowGroupIndices != null) {
                runtimeStats.addMetricValue("OrcRowGroupIndexCacheHit", 1L);
                runtimeStats.addMetricValue("OrcRowGroupIndexInMemoryBytesRead", rowGroupIndices.stream().mapToLong(RowGroupIndex::getRetainedSizeInBytes).sum());
                return rowGroupIndices;
            }
            runtimeStats.addMetricValue("OrcRowGroupIndexCacheHit", 0L);
            runtimeStats.addMetricValue("OrcRowGroupIndexStorageBytesRead", inputStream.getRetainedSizeInBytes());
        }
        rowGroupIndices = this.delegate.getRowIndexes(metadataReader, hiveWriterVersion, stripId, streamId, inputStream, bloomFilters, runtimeStats);
        if (this.rowGroupIndexCache.isPresent()) {
            this.rowGroupIndexCache.get().put((Object)new StripeReader.StripeStreamId(stripId, streamId), (Object)rowGroupIndices);
        }
        return rowGroupIndices;
    }

    private static boolean isCachedStream(Stream.StreamKind streamKind) {
        return streamKind == Stream.StreamKind.BLOOM_FILTER || streamKind == Stream.StreamKind.ROW_INDEX;
    }
}

