/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.writer.CompressionBufferPool;
import io.airlift.units.DataSize;
import java.util.Objects;
import java.util.OptionalInt;

public class ColumnWriterOptions {
    private final CompressionKind compressionKind;
    private final OptionalInt compressionLevel;
    private final int compressionMaxBufferSize;
    private final DataSize stringStatisticsLimit;
    private final boolean integerDictionaryEncodingEnabled;
    private final boolean stringDictionarySortingEnabled;
    private final boolean stringDictionaryEncodingEnabled;
    private final boolean ignoreDictionaryRowGroupSizes;
    private final int preserveDirectEncodingStripeCount;
    private final CompressionBufferPool compressionBufferPool;

    public ColumnWriterOptions(CompressionKind compressionKind, OptionalInt compressionLevel, DataSize compressionMaxBufferSize, DataSize stringStatisticsLimit, boolean integerDictionaryEncodingEnabled, boolean stringDictionarySortingEnabled, boolean stringDictionaryEncodingEnabled, boolean ignoreDictionaryRowGroupSizes, int preserveDirectEncodingStripeCount, CompressionBufferPool compressionBufferPool) {
        this.compressionKind = Objects.requireNonNull(compressionKind, "compressionKind is null");
        this.compressionLevel = Objects.requireNonNull(compressionLevel, "compressionLevel is null");
        Objects.requireNonNull(compressionMaxBufferSize, "compressionMaxBufferSize is null");
        this.compressionMaxBufferSize = Math.toIntExact(compressionMaxBufferSize.toBytes());
        this.stringStatisticsLimit = Objects.requireNonNull(stringStatisticsLimit, "stringStatisticsLimit is null");
        this.integerDictionaryEncodingEnabled = integerDictionaryEncodingEnabled;
        this.stringDictionarySortingEnabled = stringDictionarySortingEnabled;
        this.stringDictionaryEncodingEnabled = stringDictionaryEncodingEnabled;
        this.ignoreDictionaryRowGroupSizes = ignoreDictionaryRowGroupSizes;
        this.preserveDirectEncodingStripeCount = preserveDirectEncodingStripeCount;
        this.compressionBufferPool = Objects.requireNonNull(compressionBufferPool, "compressionBufferPool is null");
    }

    public CompressionKind getCompressionKind() {
        return this.compressionKind;
    }

    public OptionalInt getCompressionLevel() {
        return this.compressionLevel;
    }

    public int getCompressionMaxBufferSize() {
        return this.compressionMaxBufferSize;
    }

    public int getStringStatisticsLimit() {
        return Math.toIntExact(this.stringStatisticsLimit.toBytes());
    }

    public boolean isIntegerDictionaryEncodingEnabled() {
        return this.integerDictionaryEncodingEnabled;
    }

    public boolean isStringDictionarySortingEnabled() {
        return this.stringDictionarySortingEnabled;
    }

    public boolean isStringDictionaryEncodingEnabled() {
        return this.stringDictionaryEncodingEnabled;
    }

    public boolean isIgnoreDictionaryRowGroupSizes() {
        return this.ignoreDictionaryRowGroupSizes;
    }

    public int getPreserveDirectEncodingStripeCount() {
        return this.preserveDirectEncodingStripeCount;
    }

    public CompressionBufferPool getCompressionBufferPool() {
        return this.compressionBufferPool;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private CompressionKind compressionKind;
        private OptionalInt compressionLevel = OptionalInt.empty();
        private DataSize compressionMaxBufferSize = OrcWriterOptions.DEFAULT_MAX_COMPRESSION_BUFFER_SIZE;
        private DataSize stringStatisticsLimit = OrcWriterOptions.DEFAULT_MAX_STRING_STATISTICS_LIMIT;
        private boolean integerDictionaryEncodingEnabled;
        private boolean stringDictionarySortingEnabled = true;
        private boolean stringDictionaryEncodingEnabled = true;
        private boolean ignoreDictionaryRowGroupSizes;
        private int preserveDirectEncodingStripeCount = 0;
        private CompressionBufferPool compressionBufferPool = new CompressionBufferPool.LastUsedCompressionBufferPool();

        private Builder() {
        }

        public Builder setCompressionKind(CompressionKind compressionKind) {
            this.compressionKind = compressionKind;
            return this;
        }

        public Builder setCompressionLevel(OptionalInt compressionLevel) {
            this.compressionLevel = compressionLevel;
            return this;
        }

        public Builder setCompressionMaxBufferSize(DataSize compressionMaxBufferSize) {
            this.compressionMaxBufferSize = compressionMaxBufferSize;
            return this;
        }

        public Builder setStringStatisticsLimit(DataSize stringStatisticsLimit) {
            this.stringStatisticsLimit = stringStatisticsLimit;
            return this;
        }

        public Builder setIntegerDictionaryEncodingEnabled(boolean integerDictionaryEncodingEnabled) {
            this.integerDictionaryEncodingEnabled = integerDictionaryEncodingEnabled;
            return this;
        }

        public Builder setStringDictionarySortingEnabled(boolean stringDictionarySortingEnabled) {
            this.stringDictionarySortingEnabled = stringDictionarySortingEnabled;
            return this;
        }

        public Builder setStringDictionaryEncodingEnabled(boolean stringDictionaryEncodingEnabled) {
            this.stringDictionaryEncodingEnabled = stringDictionaryEncodingEnabled;
            return this;
        }

        public Builder setIgnoreDictionaryRowGroupSizes(boolean ignoreDictionaryRowGroupSizes) {
            this.ignoreDictionaryRowGroupSizes = ignoreDictionaryRowGroupSizes;
            return this;
        }

        public Builder setPreserveDirectEncodingStripeCount(int preserveDirectEncodingStripeCount) {
            this.preserveDirectEncodingStripeCount = preserveDirectEncodingStripeCount;
            return this;
        }

        public Builder setCompressionBufferPool(CompressionBufferPool compressionBufferPool) {
            this.compressionBufferPool = Objects.requireNonNull(compressionBufferPool, "compressionBufferPool is null");
            return this;
        }

        public ColumnWriterOptions build() {
            return new ColumnWriterOptions(this.compressionKind, this.compressionLevel, this.compressionMaxBufferSize, this.stringStatisticsLimit, this.integerDictionaryEncodingEnabled, this.stringDictionarySortingEnabled, this.stringDictionaryEncodingEnabled, this.ignoreDictionaryRowGroupSizes, this.preserveDirectEncodingStripeCount, this.compressionBufferPool);
        }
    }
}

