/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.google.common.base.MoreObjects;
import io.airlift.units.DataSize;
import java.util.Objects;

public class OrcReaderOptions {
    private final DataSize maxMergeDistance;
    private final DataSize tinyStripeThreshold;
    private final DataSize maxBlockSize;
    private final boolean zstdJniDecompressionEnabled;
    private final boolean mapNullKeysEnabled;
    private final boolean enableTimestampMicroPrecision;
    private final boolean appendRowNumber;

    public OrcReaderOptions(DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize, boolean zstdJniDecompressionEnabled) {
        this(maxMergeDistance, tinyStripeThreshold, maxBlockSize, zstdJniDecompressionEnabled, false, false, false);
    }

    public OrcReaderOptions(DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize, boolean zstdJniDecompressionEnabled, boolean appendRowNumber) {
        this(maxMergeDistance, tinyStripeThreshold, maxBlockSize, zstdJniDecompressionEnabled, false, false, appendRowNumber);
    }

    public OrcReaderOptions(DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize, boolean zstdJniDecompressionEnabled, boolean mapNullKeysEnabled, boolean enableTimestampMicroPrecision, boolean appendRowNumber) {
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.maxBlockSize = Objects.requireNonNull(maxBlockSize, "maxBlockSize is null");
        this.tinyStripeThreshold = Objects.requireNonNull(tinyStripeThreshold, "tinyStripeThreshold is null");
        this.zstdJniDecompressionEnabled = zstdJniDecompressionEnabled;
        this.mapNullKeysEnabled = mapNullKeysEnabled;
        this.enableTimestampMicroPrecision = enableTimestampMicroPrecision;
        this.appendRowNumber = appendRowNumber;
    }

    public DataSize getMaxMergeDistance() {
        return this.maxMergeDistance;
    }

    public DataSize getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public boolean isOrcZstdJniDecompressionEnabled() {
        return this.zstdJniDecompressionEnabled;
    }

    public DataSize getTinyStripeThreshold() {
        return this.tinyStripeThreshold;
    }

    public boolean mapNullKeysEnabled() {
        return this.mapNullKeysEnabled;
    }

    public boolean enableTimestampMicroPrecision() {
        return this.enableTimestampMicroPrecision;
    }

    public boolean appendRowNumber() {
        return this.appendRowNumber;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("maxMergeDistance", (Object)this.maxMergeDistance).add("tinyStripeThreshold", (Object)this.tinyStripeThreshold).add("maxBlockSize", (Object)this.maxBlockSize).add("zstdJniDecompressionEnabled", this.zstdJniDecompressionEnabled).add("mapNullKeysEnabled", this.mapNullKeysEnabled).add("enableTimestampMicroPrecision", this.enableTimestampMicroPrecision).add("appendRowNumber", this.appendRowNumber).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DataSize maxMergeDistance;
        private DataSize tinyStripeThreshold;
        private DataSize maxBlockSize;
        private boolean zstdJniDecompressionEnabled;
        private boolean mapNullKeysEnabled;
        private boolean enableTimestampMicroPrecision;
        private boolean appendRowNumber;

        private Builder() {
        }

        public Builder withMaxMergeDistance(DataSize maxMergeDistance) {
            this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
            return this;
        }

        public Builder withTinyStripeThreshold(DataSize tinyStripeThreshold) {
            this.tinyStripeThreshold = Objects.requireNonNull(tinyStripeThreshold, "tinyStripeThreshold is null");
            return this;
        }

        public Builder withMaxBlockSize(DataSize maxBlockSize) {
            this.maxBlockSize = Objects.requireNonNull(maxBlockSize, "maxBlockSize is null");
            return this;
        }

        public Builder withZstdJniDecompressionEnabled(boolean zstdJniDecompressionEnabled) {
            this.zstdJniDecompressionEnabled = zstdJniDecompressionEnabled;
            return this;
        }

        public Builder withMapNullKeysEnabled(boolean mapNullKeysEnabled) {
            this.mapNullKeysEnabled = mapNullKeysEnabled;
            return this;
        }

        public Builder withEnableTimestampMicroPrecision(boolean enableTimestampMicroPrecision) {
            this.enableTimestampMicroPrecision = enableTimestampMicroPrecision;
            return this;
        }

        public Builder withAppendRowNumber(boolean appendRowNumber) {
            this.appendRowNumber = appendRowNumber;
            return this;
        }

        public OrcReaderOptions build() {
            return new OrcReaderOptions(this.maxMergeDistance, this.tinyStripeThreshold, this.maxBlockSize, this.zstdJniDecompressionEnabled, this.mapNullKeysEnabled, this.enableTimestampMicroPrecision, this.appendRowNumber);
        }
    }
}

