/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcReaderOptions;
import io.airlift.units.DataSize;
import java.util.Objects;

public class OrcRecordReaderOptions {
    private final DataSize maxMergeDistance;
    private final DataSize tinyStripeThreshold;
    private final DataSize maxBlockSize;
    private final boolean mapNullKeysEnabled;
    private final boolean enableTimestampMicroPrecision;
    private final boolean appendRowNumber;

    public OrcRecordReaderOptions(OrcReaderOptions options) {
        this(options.getMaxMergeDistance(), options.getTinyStripeThreshold(), options.getMaxBlockSize(), options.mapNullKeysEnabled(), options.enableTimestampMicroPrecision(), options.appendRowNumber());
    }

    public OrcRecordReaderOptions(DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize, boolean mapNullKeysEnabled, boolean enableTimestampMicroPrecision, boolean appendRowNumber) {
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.maxBlockSize = Objects.requireNonNull(maxBlockSize, "maxBlockSize is null");
        this.tinyStripeThreshold = Objects.requireNonNull(tinyStripeThreshold, "tinyStripeThreshold is null");
        this.mapNullKeysEnabled = mapNullKeysEnabled;
        this.enableTimestampMicroPrecision = enableTimestampMicroPrecision;
        this.appendRowNumber = appendRowNumber;
    }

    public DataSize getMaxMergeDistance() {
        return this.maxMergeDistance;
    }

    public DataSize getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public DataSize getTinyStripeThreshold() {
        return this.tinyStripeThreshold;
    }

    public boolean mapNullKeysEnabled() {
        return this.mapNullKeysEnabled;
    }

    public boolean enableTimestampMicroPrecision() {
        return this.enableTimestampMicroPrecision;
    }

    public boolean appendRowNumber() {
        return this.appendRowNumber;
    }
}

