/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.DwrfEncryption;
import com.facebook.presto.orc.metadata.DwrfStripeCacheData;
import com.facebook.presto.orc.metadata.DwrfStripeCacheMode;
import com.facebook.presto.orc.metadata.EncryptionGroup;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.KeyProvider;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.StripeEncryptionGroup;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.proto.DwrfProto;
import com.facebook.presto.orc.protobuf.ByteString;
import com.facebook.presto.orc.protobuf.MessageLite;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CountingOutputStream;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class DwrfMetadataWriter
implements MetadataWriter {
    private static final int DWRF_WRITER_VERSION = 1;
    public static final Map<String, Slice> STATIC_METADATA = ImmutableMap.builder().put((Object)"orc.writer.name", (Object)Slices.utf8Slice((String)"presto")).put((Object)"orc.writer.version", (Object)Slices.utf8Slice((String)String.valueOf(1))).build();

    @Override
    public List<Integer> getOrcMetadataVersion() {
        return ImmutableList.of();
    }

    @Override
    public int writePostscript(SliceOutput output, int footerLength, int metadataLength, CompressionKind compression, int compressionBlockSize, Optional<DwrfStripeCacheData> dwrfStripeCacheData) throws IOException {
        DwrfProto.PostScript.Builder postScriptBuilder = DwrfProto.PostScript.newBuilder().setFooterLength((long)footerLength).setWriterVersion(1).setCompression(DwrfMetadataWriter.toCompression(compression)).setCompressionBlockSize((long)compressionBlockSize);
        dwrfStripeCacheData.ifPresent(cache -> {
            postScriptBuilder.setCacheMode(DwrfMetadataWriter.toStripeCacheMode(cache.getDwrfStripeCacheMode()));
            postScriptBuilder.setCacheSize(cache.getDwrfStripeCacheSize());
        });
        DwrfProto.PostScript postScriptProtobuf = postScriptBuilder.build();
        return DwrfMetadataWriter.writeProtobufObject((OutputStream)output, (MessageLite)postScriptProtobuf);
    }

    @Override
    public int writeDwrfStripeCache(SliceOutput output, Optional<DwrfStripeCacheData> dwrfStripeCacheData) {
        int size = 0;
        if (dwrfStripeCacheData.isPresent()) {
            DwrfStripeCacheData cache = dwrfStripeCacheData.get();
            size = cache.getDwrfStripeCacheSize();
            output.writeBytes(cache.getDwrfStripeCacheSlice(), 0, size);
        }
        return size;
    }

    @Override
    public int writeMetadata(SliceOutput output, Metadata metadata) {
        return 0;
    }

    @Override
    public int writeFooter(SliceOutput output, Footer footer) throws IOException {
        DwrfProto.Footer.Builder footerProtobuf = DwrfProto.Footer.newBuilder().setNumberOfRows(footer.getNumberOfRows()).setRowIndexStride(footer.getRowsInRowGroup()).addAllStripes((Iterable)footer.getStripes().stream().map(DwrfMetadataWriter::toStripeInformation).collect(ImmutableList.toImmutableList())).addAllTypes((Iterable)footer.getTypes().stream().map(DwrfMetadataWriter::toType).collect(ImmutableList.toImmutableList())).addAllStatistics((Iterable)footer.getFileStats().stream().map(DwrfMetadataWriter::toColumnStatistics).collect(ImmutableList.toImmutableList())).addAllMetadata((Iterable)footer.getUserMetadata().entrySet().stream().map(DwrfMetadataWriter::toUserMetadata).collect(ImmutableList.toImmutableList())).addAllMetadata((Iterable)STATIC_METADATA.entrySet().stream().map(DwrfMetadataWriter::toUserMetadata).collect(ImmutableList.toImmutableList()));
        if (footer.getEncryption().isPresent()) {
            footerProtobuf.setEncryption(DwrfMetadataWriter.toEncryption(footer.getEncryption().get()));
        }
        if (footer.getRawSize().isPresent()) {
            footerProtobuf.setRawDataSize(footer.getRawSize().getAsLong());
        }
        if (footer.getDwrfStripeCacheOffsets().isPresent()) {
            footerProtobuf.addAllStripeCacheOffsets((Iterable)footer.getDwrfStripeCacheOffsets().get());
        }
        return DwrfMetadataWriter.writeProtobufObject((OutputStream)output, (MessageLite)footerProtobuf.build());
    }

    @VisibleForTesting
    static DwrfProto.StripeInformation toStripeInformation(StripeInformation stripe) {
        DwrfProto.StripeInformation.Builder builder = DwrfProto.StripeInformation.newBuilder().setNumberOfRows(stripe.getNumberOfRows()).setOffset(stripe.getOffset()).setIndexLength(stripe.getIndexLength()).setDataLength(stripe.getDataLength()).setFooterLength(stripe.getFooterLength()).addAllKeyMetadata((Iterable)stripe.getKeyMetadata().stream().map(ByteString::copyFrom).collect(ImmutableList.toImmutableList()));
        if (stripe.getRawDataSize().isPresent()) {
            builder.setRawDataSize(stripe.getRawDataSize().getAsLong());
        }
        return builder.build();
    }

    private static DwrfProto.Type toType(OrcType type) {
        DwrfProto.Type.Builder builder = DwrfProto.Type.newBuilder().setKind(DwrfMetadataWriter.toTypeKind(type.getOrcTypeKind())).addAllSubtypes(type.getFieldTypeIndexes()).addAllFieldNames(type.getFieldNames());
        return builder.build();
    }

    private static DwrfProto.Type.Kind toTypeKind(OrcType.OrcTypeKind orcTypeKind) {
        switch (orcTypeKind) {
            case BOOLEAN: {
                return DwrfProto.Type.Kind.BOOLEAN;
            }
            case BYTE: {
                return DwrfProto.Type.Kind.BYTE;
            }
            case SHORT: {
                return DwrfProto.Type.Kind.SHORT;
            }
            case INT: {
                return DwrfProto.Type.Kind.INT;
            }
            case LONG: {
                return DwrfProto.Type.Kind.LONG;
            }
            case FLOAT: {
                return DwrfProto.Type.Kind.FLOAT;
            }
            case DOUBLE: {
                return DwrfProto.Type.Kind.DOUBLE;
            }
            case STRING: 
            case VARCHAR: {
                return DwrfProto.Type.Kind.STRING;
            }
            case BINARY: {
                return DwrfProto.Type.Kind.BINARY;
            }
            case TIMESTAMP: {
                return DwrfProto.Type.Kind.TIMESTAMP;
            }
            case LIST: {
                return DwrfProto.Type.Kind.LIST;
            }
            case MAP: {
                return DwrfProto.Type.Kind.MAP;
            }
            case STRUCT: {
                return DwrfProto.Type.Kind.STRUCT;
            }
            case UNION: {
                return DwrfProto.Type.Kind.UNION;
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)orcTypeKind));
    }

    public static DwrfProto.ColumnStatistics toColumnStatistics(ColumnStatistics columnStatistics) {
        DwrfProto.ColumnStatistics.Builder builder = DwrfProto.ColumnStatistics.newBuilder();
        if (columnStatistics.hasNumberOfValues()) {
            builder.setNumberOfValues(columnStatistics.getNumberOfValues());
        }
        if (columnStatistics.getBooleanStatistics() != null) {
            builder.setBucketStatistics(DwrfProto.BucketStatistics.newBuilder().addCount(columnStatistics.getBooleanStatistics().getTrueValueCount()).build());
        }
        if (columnStatistics.getIntegerStatistics() != null) {
            DwrfProto.IntegerStatistics.Builder integerStatistics = DwrfProto.IntegerStatistics.newBuilder().setMinimum(columnStatistics.getIntegerStatistics().getMin().longValue()).setMaximum(columnStatistics.getIntegerStatistics().getMax().longValue());
            if (columnStatistics.getIntegerStatistics().getSum() != null) {
                integerStatistics.setSum(columnStatistics.getIntegerStatistics().getSum().longValue());
            }
            builder.setIntStatistics(integerStatistics.build());
        }
        if (columnStatistics.getDoubleStatistics() != null) {
            builder.setDoubleStatistics(DwrfProto.DoubleStatistics.newBuilder().setMinimum(columnStatistics.getDoubleStatistics().getMin().doubleValue()).setMaximum(columnStatistics.getDoubleStatistics().getMax().doubleValue()).build());
        }
        if (columnStatistics.getStringStatistics() != null) {
            DwrfProto.StringStatistics.Builder statisticsBuilder = DwrfProto.StringStatistics.newBuilder();
            if (columnStatistics.getStringStatistics().getMin() != null) {
                statisticsBuilder.setMinimumBytes(ByteString.copyFrom((byte[])columnStatistics.getStringStatistics().getMin().getBytes()));
            }
            if (columnStatistics.getStringStatistics().getMax() != null) {
                statisticsBuilder.setMaximumBytes(ByteString.copyFrom((byte[])columnStatistics.getStringStatistics().getMax().getBytes()));
            }
            statisticsBuilder.setSum(columnStatistics.getStringStatistics().getSum());
            builder.setStringStatistics(statisticsBuilder.build());
        }
        if (columnStatistics.getBinaryStatistics() != null) {
            builder.setBinaryStatistics(DwrfProto.BinaryStatistics.newBuilder().setSum(columnStatistics.getBinaryStatistics().getSum()).build());
        }
        return builder.build();
    }

    private static DwrfProto.UserMetadataItem toUserMetadata(Map.Entry<String, Slice> entry) {
        return DwrfProto.UserMetadataItem.newBuilder().setName(entry.getKey()).setValue(ByteString.copyFrom((byte[])entry.getValue().getBytes())).build();
    }

    @Override
    public int writeStripeFooter(SliceOutput output, StripeFooter footer) throws IOException {
        DwrfProto.StripeFooter footerProtobuf = DwrfProto.StripeFooter.newBuilder().addAllStreams((Iterable)footer.getStreams().stream().map(DwrfMetadataWriter::toStream).collect(ImmutableList.toImmutableList())).addAllColumns((Iterable)footer.getColumnEncodings().entrySet().stream().map(entry -> DwrfMetadataWriter.toColumnEncoding((Integer)entry.getKey(), (ColumnEncoding)entry.getValue())).collect(ImmutableList.toImmutableList())).addAllEncryptedGroups((Iterable)footer.getStripeEncryptionGroups().stream().map(group -> ByteString.copyFrom((byte[])group.getBytes())).collect(ImmutableList.toImmutableList())).build();
        return DwrfMetadataWriter.writeProtobufObject((OutputStream)output, (MessageLite)footerProtobuf);
    }

    private static DwrfProto.Stream toStream(Stream stream) {
        DwrfProto.Stream.Builder streamBuilder = DwrfProto.Stream.newBuilder().setColumn(stream.getColumn()).setKind(DwrfMetadataWriter.toStreamKind(stream.getStreamKind())).setLength((long)stream.getLength()).setUseVInts(stream.isUseVInts());
        stream.getOffset().ifPresent(arg_0 -> ((DwrfProto.Stream.Builder)streamBuilder).setOffset(arg_0));
        return streamBuilder.build();
    }

    private static DwrfProto.Stream.Kind toStreamKind(Stream.StreamKind streamKind) {
        switch (streamKind) {
            case PRESENT: {
                return DwrfProto.Stream.Kind.PRESENT;
            }
            case DATA: {
                return DwrfProto.Stream.Kind.DATA;
            }
            case SECONDARY: {
                return DwrfProto.Stream.Kind.NANO_DATA;
            }
            case LENGTH: {
                return DwrfProto.Stream.Kind.LENGTH;
            }
            case DICTIONARY_DATA: {
                return DwrfProto.Stream.Kind.DICTIONARY_DATA;
            }
            case DICTIONARY_COUNT: {
                return DwrfProto.Stream.Kind.DICTIONARY_COUNT;
            }
            case ROW_INDEX: {
                return DwrfProto.Stream.Kind.ROW_INDEX;
            }
        }
        throw new IllegalArgumentException("Unsupported stream kind: " + (Object)((Object)streamKind));
    }

    public static DwrfProto.ColumnEncoding toColumnEncoding(int columnId, ColumnEncoding columnEncoding) {
        Preconditions.checkArgument((!columnEncoding.getAdditionalSequenceEncodings().isPresent() ? 1 : 0) != 0, (Object)("DWRF writer doesn't support writing columns with non-zero sequence IDs: " + columnEncoding));
        return DwrfProto.ColumnEncoding.newBuilder().setKind(DwrfMetadataWriter.toColumnEncodingKind(columnEncoding.getColumnEncodingKind())).setDictionarySize(columnEncoding.getDictionarySize()).setColumn(columnId).setSequence(0).build();
    }

    private static DwrfProto.ColumnEncoding.Kind toColumnEncodingKind(ColumnEncoding.ColumnEncodingKind columnEncodingKind) {
        switch (columnEncodingKind) {
            case DIRECT: {
                return DwrfProto.ColumnEncoding.Kind.DIRECT;
            }
            case DICTIONARY: {
                return DwrfProto.ColumnEncoding.Kind.DICTIONARY;
            }
        }
        throw new IllegalArgumentException("Unsupported column encoding kind: " + (Object)((Object)columnEncodingKind));
    }

    @Override
    public int writeRowIndexes(SliceOutput output, List<RowGroupIndex> rowGroupIndexes) throws IOException {
        DwrfProto.RowIndex rowIndexProtobuf = DwrfProto.RowIndex.newBuilder().addAllEntry((Iterable)rowGroupIndexes.stream().map(DwrfMetadataWriter::toRowGroupIndex).collect(ImmutableList.toImmutableList())).build();
        return DwrfMetadataWriter.writeProtobufObject((OutputStream)output, (MessageLite)rowIndexProtobuf);
    }

    private static DwrfProto.RowIndexEntry toRowGroupIndex(RowGroupIndex rowGroupIndex) {
        return DwrfProto.RowIndexEntry.newBuilder().addAllPositions((Iterable)rowGroupIndex.getPositions().stream().map(Integer::longValue).collect(ImmutableList.toImmutableList())).setStatistics(DwrfMetadataWriter.toColumnStatistics(rowGroupIndex.getColumnStatistics())).build();
    }

    private static DwrfProto.CompressionKind toCompression(CompressionKind compressionKind) {
        switch (compressionKind) {
            case NONE: {
                return DwrfProto.CompressionKind.NONE;
            }
            case ZLIB: {
                return DwrfProto.CompressionKind.ZLIB;
            }
            case SNAPPY: {
                return DwrfProto.CompressionKind.SNAPPY;
            }
            case LZ4: {
                return DwrfProto.CompressionKind.LZ4;
            }
            case ZSTD: {
                return DwrfProto.CompressionKind.ZSTD;
            }
        }
        throw new IllegalArgumentException("Unsupported compression kind: " + (Object)((Object)compressionKind));
    }

    private static DwrfProto.Encryption toEncryption(DwrfEncryption encryption) {
        return DwrfProto.Encryption.newBuilder().setKeyProvider(DwrfMetadataWriter.toKeyProvider(encryption.getKeyProvider())).addAllEncryptionGroups((Iterable)encryption.getEncryptionGroups().stream().map(group -> DwrfMetadataWriter.toEncryptionGroup(group)).collect(ImmutableList.toImmutableList())).build();
    }

    private static DwrfProto.Encryption.KeyProvider toKeyProvider(KeyProvider keyProvider) {
        switch (keyProvider) {
            case CRYPTO_SERVICE: {
                return DwrfProto.Encryption.KeyProvider.CRYPTO_SERVICE;
            }
            case UNKNOWN: {
                return DwrfProto.Encryption.KeyProvider.UNKNOWN;
            }
        }
        throw new UnsupportedOperationException(String.format("unknown key provider: %s", new Object[]{keyProvider}));
    }

    private static DwrfProto.EncryptionGroup toEncryptionGroup(EncryptionGroup encryptionGroup) {
        return DwrfProto.EncryptionGroup.newBuilder().addAllNodes(encryptionGroup.getNodes()).addAllStatistics((Iterable)encryptionGroup.getStatistics().stream().map(statsSlice -> ByteString.copyFrom((byte[])statsSlice.getBytes())).collect(ImmutableList.toImmutableList())).build();
    }

    public static DwrfProto.StripeEncryptionGroup toStripeEncryptionGroup(StripeEncryptionGroup stripeEncryptionGroup) {
        return DwrfProto.StripeEncryptionGroup.newBuilder().addAllStreams((Iterable)stripeEncryptionGroup.getStreams().stream().map(DwrfMetadataWriter::toStream).collect(ImmutableList.toImmutableList())).addAllEncoding((Iterable)stripeEncryptionGroup.getColumnEncodings().entrySet().stream().map(entry -> DwrfMetadataWriter.toColumnEncoding((Integer)entry.getKey(), (ColumnEncoding)entry.getValue())).collect(ImmutableList.toImmutableList())).build();
    }

    public static DwrfProto.FileStatistics toFileStatistics(List<ColumnStatistics> columnStatistics) {
        List dwrfColumnStatistics = columnStatistics.stream().map(DwrfMetadataWriter::toColumnStatistics).collect(Collectors.toList());
        return DwrfProto.FileStatistics.newBuilder().addAllStatistics(dwrfColumnStatistics).build();
    }

    private static DwrfProto.StripeCacheMode toStripeCacheMode(DwrfStripeCacheMode dwrfStripeCacheMode) {
        switch (dwrfStripeCacheMode) {
            case NONE: {
                return DwrfProto.StripeCacheMode.NA;
            }
            case INDEX: {
                return DwrfProto.StripeCacheMode.INDEX;
            }
            case FOOTER: {
                return DwrfProto.StripeCacheMode.FOOTER;
            }
            case INDEX_AND_FOOTER: {
                return DwrfProto.StripeCacheMode.BOTH;
            }
        }
        throw new IllegalArgumentException("Unsupported mode: " + (Object)((Object)dwrfStripeCacheMode));
    }

    private static int writeProtobufObject(OutputStream output, MessageLite object) throws IOException {
        CountingOutputStream countingOutput = new CountingOutputStream(output);
        object.writeTo((OutputStream)countingOutput);
        return Math.toIntExact(countingOutput.getCount());
    }
}

