/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.reader.HierarchicalFilter;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class ListFilter
implements HierarchicalFilter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ListFilter.class).instanceSize();
    @Nullable
    private final HierarchicalFilter parent;
    @Nullable
    private final HierarchicalFilter child;
    private final TupleDomainFilter[] tupleDomainFilters;
    @Nullable
    private final TupleDomainFilter.PositionalFilter positionalFilter;
    private TupleDomainFilter[] elementTupleDomainFilters;
    private final long[] subscriptFilters;
    private long[] elementFilters;
    private int[] topLevelOffsets;
    private int topLevelOffsetCount;
    private final long nullFilters;
    private final TupleDomainFilter.NullsFilter nullsFilter;
    private boolean[] nullsAllowed;
    private boolean[] nonNullsAllowed;
    private boolean[] indexOutOfBounds;

    public ListFilter(StreamDescriptor streamDescriptor, Map<Subfield, TupleDomainFilter> subfieldFilters) {
        this(streamDescriptor, subfieldFilters, 0, null);
    }

    public ListFilter(StreamDescriptor streamDescriptor, Map<Subfield, TupleDomainFilter> subfieldFilters, int level, HierarchicalFilter parent) {
        Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        Objects.requireNonNull(subfieldFilters, "subfieldFilters is null");
        Preconditions.checkArgument((!subfieldFilters.isEmpty() ? 1 : 0) != 0, (Object)"subfieldFilters is empty");
        Preconditions.checkArgument((subfieldFilters.size() <= 64 ? 1 : 0) != 0, (Object)"Number of filters cannot exceed 64");
        Preconditions.checkArgument((level == 0 && parent == null || level > 0 && parent != null ? 1 : 0) != 0, (Object)"parent must be null for top-level filter and non-null otherwise");
        this.parent = parent;
        this.tupleDomainFilters = subfieldFilters.values().toArray(new TupleDomainFilter[0]);
        this.subscriptFilters = ListFilter.extractFilters(subfieldFilters, level, subfield -> subfield.getPath().size() > level);
        this.nullFilters = ListFilter.combineFilters(ListFilter.extractFilters(subfieldFilters, level, subfield -> subfield.getPath().size() == level + 1));
        this.nullsFilter = this.nullFilters > 0L ? new TupleDomainFilter.NullsFilter() : null;
        StreamDescriptor elementStreamDescriptor = streamDescriptor.getNestedStreams().get(0);
        this.child = HierarchicalFilter.createHierarchicalFilter(elementStreamDescriptor, subfieldFilters, level + 1, this);
        this.positionalFilter = this.child == null ? new TupleDomainFilter.PositionalFilter() : null;
    }

    public HierarchicalFilter getParent() {
        return this.parent;
    }

    @Override
    public HierarchicalFilter getChild() {
        return this.child;
    }

    @Override
    public TupleDomainFilter.NullsFilter getNullsFilter() {
        return this.nullsFilter;
    }

    @Override
    public int[] getTopLevelOffsets() {
        return this.topLevelOffsets;
    }

    @Override
    public int getTopLevelOffsetCount() {
        return this.topLevelOffsetCount;
    }

    @Override
    public long[] getElementFilters() {
        return this.elementFilters;
    }

    @Override
    public TupleDomainFilter.PositionalFilter getPositionalFilter() {
        return this.positionalFilter;
    }

    public void populateElementFilters(int positionCount, boolean[] nulls, int[] lengths, int lengthSum) {
        this.elementFilters = ListFilter.ensureCapacity(this.elementFilters, lengthSum);
        this.topLevelOffsetCount = this.parent == null ? positionCount + 1 : this.parent.getTopLevelOffsetCount();
        this.topLevelOffsets = ListFilter.ensureCapacity(this.topLevelOffsets, this.topLevelOffsetCount);
        this.indexOutOfBounds = ListFilter.ensureCapacity(this.indexOutOfBounds, this.topLevelOffsetCount);
        Arrays.fill(this.indexOutOfBounds, 0, this.topLevelOffsetCount, false);
        int elementPosition = 0;
        if (this.parent == null) {
            block0: for (int i = 0; i < positionCount; ++i) {
                int j;
                this.topLevelOffsets[i] = elementPosition;
                for (j = 0; j < lengths[i]; ++j) {
                    this.elementFilters[elementPosition] = j < this.subscriptFilters.length ? this.subscriptFilters[j] : 0L;
                    ++elementPosition;
                }
                if (nulls != null && nulls[i]) continue;
                for (j = lengths[i]; j < this.subscriptFilters.length; ++j) {
                    if (this.subscriptFilters[j] <= 0L) continue;
                    this.indexOutOfBounds[i] = true;
                    continue block0;
                }
            }
        } else {
            int[] parentTopLevelOffsets = this.updateParentTopLevelOffsets();
            long[] parentElementFilters = this.parent.getElementFilters();
            int offsetIndex = 0;
            int nextOffset = parentTopLevelOffsets[offsetIndex + 1];
            block3: for (int i = 0; i < positionCount; ++i) {
                int j;
                while (i == nextOffset) {
                    this.topLevelOffsets[++offsetIndex] = elementPosition;
                    nextOffset = parentTopLevelOffsets[offsetIndex + 1];
                }
                long parentElementFilter = parentElementFilters[i];
                for (j = 0; j < lengths[i]; ++j) {
                    this.elementFilters[elementPosition] = this.subscriptFilters != null && j < this.subscriptFilters.length ? parentElementFilter & this.subscriptFilters[j] : 0L;
                    ++elementPosition;
                }
                if (this.subscriptFilters == null || nulls != null && nulls[i]) continue;
                for (j = lengths[i]; j < this.subscriptFilters.length; ++j) {
                    if ((parentElementFilter & this.subscriptFilters[j]) <= 0L) continue;
                    this.indexOutOfBounds[offsetIndex] = true;
                    continue block3;
                }
            }
            while (offsetIndex < this.topLevelOffsetCount - 1) {
                this.topLevelOffsets[++offsetIndex] = elementPosition;
            }
        }
        this.topLevelOffsets[this.topLevelOffsetCount - 1] = elementPosition;
        if (this.positionalFilter != null) {
            this.setupPositionalFilter();
        } else if (this.nullsFilter != null) {
            this.setupNullsFilter();
        }
    }

    private int[] updateParentTopLevelOffsets() {
        int[] parentTopLevelOffsets = this.parent.getTopLevelOffsets();
        TupleDomainFilter.NullsFilter nullsFilter = this.parent.getNullsFilter();
        if (nullsFilter != null) {
            boolean[] failed = nullsFilter.getFailed();
            int skipped = 0;
            for (int i = 0; i < this.topLevelOffsetCount - 1; ++i) {
                int n = i;
                parentTopLevelOffsets[n] = parentTopLevelOffsets[n] - skipped;
                if (!failed[i]) continue;
                skipped += parentTopLevelOffsets[i + 1] - parentTopLevelOffsets[i] - skipped;
            }
            int n = this.topLevelOffsetCount - 1;
            parentTopLevelOffsets[n] = parentTopLevelOffsets[n] - skipped;
        }
        return parentTopLevelOffsets;
    }

    private void setupPositionalFilter() {
        int count = this.topLevelOffsets[this.topLevelOffsetCount - 1];
        if (this.elementTupleDomainFilters == null || this.elementTupleDomainFilters.length < count) {
            this.elementTupleDomainFilters = new TupleDomainFilter[count];
        }
        for (int i = 0; i < count; ++i) {
            long filter = this.elementFilters[i];
            this.elementTupleDomainFilters[i] = filter > 0L ? this.tupleDomainFilters[Long.numberOfTrailingZeros(filter)] : null;
        }
        this.positionalFilter.setFilters(this.elementTupleDomainFilters, this.topLevelOffsets);
    }

    private void setupNullsFilter() {
        int count = this.topLevelOffsets[this.topLevelOffsetCount - 1];
        this.nullsAllowed = ListFilter.ensureCapacity(this.nullsAllowed, count);
        this.nonNullsAllowed = ListFilter.ensureCapacity(this.nonNullsAllowed, count);
        for (int i = 0; i < count; ++i) {
            long filter = this.elementFilters[i] & this.nullFilters;
            if (filter > 0L) {
                TupleDomainFilter tupleDomainFilter = this.tupleDomainFilters[Long.numberOfTrailingZeros(filter)];
                this.nullsAllowed[i] = tupleDomainFilter == TupleDomainFilter.IS_NULL;
                this.nonNullsAllowed[i] = tupleDomainFilter == TupleDomainFilter.IS_NOT_NULL;
                continue;
            }
            this.nullsAllowed[i] = true;
            this.nonNullsAllowed[i] = true;
        }
        this.nullsFilter.setup(this.nullsAllowed, this.nonNullsAllowed, this.topLevelOffsets);
    }

    @Override
    public boolean[] getTopLevelFailed() {
        if (this.child == null) {
            return this.positionalFilter.getFailed();
        }
        boolean[] failed = this.child.getTopLevelFailed();
        if (this.nullsFilter != null) {
            for (int i = 0; i < failed.length; ++i) {
                int n = i;
                failed[n] = failed[n] | this.nullsFilter.getFailed()[i];
            }
        }
        return failed;
    }

    @Override
    public boolean[] getTopLevelIndexOutOfBounds() {
        if (this.child == null) {
            return this.indexOutOfBounds;
        }
        boolean[] indexOutOfBounds = this.child.getTopLevelIndexOutOfBounds();
        for (int i = 0; i < indexOutOfBounds.length; ++i) {
            int n = i;
            indexOutOfBounds[n] = indexOutOfBounds[n] | this.indexOutOfBounds[i];
        }
        return indexOutOfBounds;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((long[])this.elementFilters) + SizeOf.sizeOf((Object[])this.tupleDomainFilters) + SizeOf.sizeOf((long[])this.subscriptFilters) + SizeOf.sizeOf((Object[])this.elementTupleDomainFilters) + SizeOf.sizeOf((int[])this.topLevelOffsets) + SizeOf.sizeOf((boolean[])this.nonNullsAllowed) + SizeOf.sizeOf((boolean[])this.nullsAllowed) + SizeOf.sizeOf((boolean[])this.indexOutOfBounds) + (this.child != null ? this.child.getRetainedSizeInBytes() : 0L);
    }

    private static long[] extractFilters(Map<Subfield, TupleDomainFilter> filters, int level, Predicate<Subfield> predicate) {
        int maxSubscript = -1;
        int[] subscripts = new int[filters.size()];
        int index = 0;
        for (Subfield subfield : filters.keySet()) {
            if (predicate.test(subfield)) {
                subscripts[index] = ListFilter.toSubscript(subfield, level);
                maxSubscript = Math.max(maxSubscript, subscripts[index]);
            } else {
                subscripts[index] = -1;
            }
            ++index;
        }
        if (maxSubscript == -1) {
            return null;
        }
        long[] filterCodes = new long[maxSubscript + 1];
        for (int i = 0; i < subscripts.length; ++i) {
            if (subscripts[i] == -1) continue;
            int n = subscripts[i];
            filterCodes[n] = filterCodes[n] | (long)(1 << i);
        }
        return filterCodes;
    }

    private static int toSubscript(Subfield subfield, int level) {
        Preconditions.checkArgument((subfield.getPath().size() > level ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)(subfield.getPath().get(level) instanceof Subfield.LongSubscript));
        return Math.toIntExact(((Subfield.LongSubscript)subfield.getPath().get(level)).getIndex()) - 1;
    }

    private static long combineFilters(long[] filters) {
        if (filters == null) {
            return 0L;
        }
        int combined = 0;
        for (long filter : filters) {
            combined = (int)((long)combined | filter);
        }
        return combined;
    }

    private static int[] ensureCapacity(int[] buffer, int capacity) {
        if (buffer == null || buffer.length < capacity) {
            return new int[capacity];
        }
        return buffer;
    }

    private static long[] ensureCapacity(long[] buffer, int capacity) {
        if (buffer == null || buffer.length < capacity) {
            return new long[capacity];
        }
        return buffer;
    }

    private static boolean[] ensureCapacity(boolean[] buffer, int capacity) {
        if (buffer == null || buffer.length < capacity) {
            return new boolean[capacity];
        }
        return buffer;
    }
}

