/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockLease;
import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcRecordReaderOptions;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.reader.MapDirectSelectiveStreamReader;
import com.facebook.presto.orc.reader.MapFlatSelectiveStreamReader;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class MapSelectiveStreamReader
implements SelectiveStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapSelectiveStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    private final MapDirectSelectiveStreamReader directReader;
    private final MapFlatSelectiveStreamReader flatReader;
    private SelectiveStreamReader currentReader;

    public MapSelectiveStreamReader(StreamDescriptor streamDescriptor, Map<Subfield, TupleDomainFilter> filters, List<Subfield> requiredSubfields, Optional<Type> outputType, DateTimeZone hiveStorageTimeZone, OrcRecordReaderOptions options, boolean legacyMapSubscript, OrcAggregatedMemoryContext systemMemoryContext) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.directReader = new MapDirectSelectiveStreamReader(streamDescriptor, filters, requiredSubfields, outputType, hiveStorageTimeZone, options, legacyMapSubscript, systemMemoryContext);
        this.flatReader = new MapFlatSelectiveStreamReader(streamDescriptor, filters, requiredSubfields, outputType, hiveStorageTimeZone, options, legacyMapSubscript, systemMemoryContext);
    }

    @Override
    public void startStripe(Stripe stripe) throws IOException {
        ColumnEncoding.ColumnEncodingKind kind = stripe.getColumnEncodings().get(this.streamDescriptor.getStreamId()).getColumnEncoding(this.streamDescriptor.getSequence()).getColumnEncodingKind();
        if (kind == ColumnEncoding.ColumnEncodingKind.DIRECT || kind == ColumnEncoding.ColumnEncodingKind.DIRECT_V2 || kind == ColumnEncoding.ColumnEncodingKind.DWRF_DIRECT) {
            this.currentReader = this.directReader;
        } else if (kind == ColumnEncoding.ColumnEncodingKind.DWRF_MAP_FLAT) {
            this.currentReader = this.flatReader;
        } else {
            throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)kind));
        }
        this.currentReader.startStripe(stripe);
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.currentReader.startRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.directReader.getRetainedSizeInBytes() + this.flatReader.getRetainedSizeInBytes();
    }

    @Override
    public int read(int offset, int[] positions, int positionCount) throws IOException {
        return this.currentReader.read(offset, positions, positionCount);
    }

    @Override
    public int[] getReadPositions() {
        return this.currentReader.getReadPositions();
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        return this.currentReader.getBlock(positions, positionCount);
    }

    @Override
    public BlockLease getBlockView(int[] positions, int positionCount) {
        return this.currentReader.getBlockView(positions, positionCount);
    }

    @Override
    public void throwAnyError(int[] positions, int positionCount) {
        this.currentReader.throwAnyError(positions, positionCount);
    }

    @Override
    public void close() {
        this.directReader.close();
        this.flatReader.close();
    }
}

