/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.checkpoint.BooleanStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.DecimalStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressedMetadataWriter;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.LongDecimalStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.ShortDecimalStatisticsBuilder;
import com.facebook.presto.orc.stream.DecimalOutputStream;
import com.facebook.presto.orc.stream.LongOutputStream;
import com.facebook.presto.orc.stream.LongOutputStreamV2;
import com.facebook.presto.orc.stream.PresentOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class DecimalColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DecimalColumnWriter.class).instanceSize();
    private final int column;
    private final DecimalType type;
    private final ColumnEncoding columnEncoding;
    private final boolean compressed;
    private final DecimalOutputStream dataStream;
    private final LongOutputStream scaleStream;
    private final PresentOutputStream presentStream;
    private final CompressedMetadataWriter metadataWriter;
    private final List<ColumnStatistics> rowGroupColumnStatistics = new ArrayList<ColumnStatistics>();
    private long columnStatisticsRetainedSizeInBytes;
    private ShortDecimalStatisticsBuilder shortDecimalStatisticsBuilder;
    private LongDecimalStatisticsBuilder longDecimalStatisticsBuilder;
    private boolean closed;

    public DecimalColumnWriter(int column, Type type, ColumnWriterOptions columnWriterOptions, OrcEncoding orcEncoding, MetadataWriter metadataWriter) {
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0, (Object)"column is negative");
        Objects.requireNonNull(columnWriterOptions, "columnWriterOptions is null");
        Preconditions.checkArgument((orcEncoding != OrcEncoding.DWRF ? 1 : 0) != 0, (String)"DWRF does not support %s type", (Object)type);
        Objects.requireNonNull(metadataWriter, "metadataWriter is null");
        this.column = column;
        this.type = (DecimalType)Objects.requireNonNull(type, "type is null");
        this.compressed = columnWriterOptions.getCompressionKind() != CompressionKind.NONE;
        this.columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT_V2, 0);
        this.dataStream = new DecimalOutputStream(columnWriterOptions);
        this.scaleStream = new LongOutputStreamV2(columnWriterOptions, true, Stream.StreamKind.SECONDARY);
        this.presentStream = new PresentOutputStream(columnWriterOptions, Optional.empty());
        this.metadataWriter = new CompressedMetadataWriter(metadataWriter, columnWriterOptions, Optional.empty());
        if (this.type.isShort()) {
            this.shortDecimalStatisticsBuilder = new ShortDecimalStatisticsBuilder(this.type.getScale());
        } else {
            this.longDecimalStatisticsBuilder = new LongDecimalStatisticsBuilder();
        }
    }

    @Override
    public Map<Integer, ColumnEncoding> getColumnEncodings() {
        return ImmutableMap.of((Object)this.column, (Object)this.columnEncoding);
    }

    @Override
    public void beginRowGroup() {
        this.presentStream.recordCheckpoint();
        this.dataStream.recordCheckpoint();
        this.scaleStream.recordCheckpoint();
    }

    @Override
    public long writeBlock(Block block) {
        int position;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Block is empty");
        for (position = 0; position < block.getPositionCount(); ++position) {
            this.presentStream.writeBoolean(!block.isNull(position));
        }
        if (this.type.isShort()) {
            for (position = 0; position < block.getPositionCount(); ++position) {
                if (block.isNull(position)) continue;
                long value = this.type.getLong(block, position);
                this.dataStream.writeUnscaledValue(value);
                this.shortDecimalStatisticsBuilder.addValue(value);
            }
        } else {
            for (position = 0; position < block.getPositionCount(); ++position) {
                if (block.isNull(position)) continue;
                Slice value = this.type.getSlice(block, position);
                this.dataStream.writeUnscaledValue(value);
                this.longDecimalStatisticsBuilder.addValue(new BigDecimal(Decimals.decodeUnscaledValue((Slice)value), this.type.getScale()));
            }
        }
        int nonNullValueCount = 0;
        for (int position2 = 0; position2 < block.getPositionCount(); ++position2) {
            if (block.isNull(position2)) continue;
            this.scaleStream.writeLong(this.type.getScale());
            ++nonNullValueCount;
        }
        long singleValueSize = 8 + (this.type.isShort() ? 8 : 16);
        return (long)(block.getPositionCount() - nonNullValueCount) * 1L + (long)nonNullValueCount * singleValueSize;
    }

    @Override
    public Map<Integer, ColumnStatistics> finishRowGroup() {
        ColumnStatistics statistics;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.type.isShort()) {
            statistics = this.shortDecimalStatisticsBuilder.buildColumnStatistics();
            this.shortDecimalStatisticsBuilder = new ShortDecimalStatisticsBuilder(this.type.getScale());
        } else {
            statistics = this.longDecimalStatisticsBuilder.buildColumnStatistics();
            this.longDecimalStatisticsBuilder = new LongDecimalStatisticsBuilder();
        }
        this.rowGroupColumnStatistics.add(statistics);
        this.columnStatisticsRetainedSizeInBytes += statistics.getRetainedSizeInBytes();
        return ImmutableMap.of((Object)this.column, (Object)statistics);
    }

    @Override
    public void close() {
        this.closed = true;
        this.dataStream.close();
        this.scaleStream.close();
        this.presentStream.close();
    }

    @Override
    public Map<Integer, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableMap.of((Object)this.column, (Object)ColumnStatistics.mergeColumnStatistics(this.rowGroupColumnStatistics));
    }

    @Override
    public List<StreamDataOutput> getIndexStreams() throws IOException {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder rowGroupIndexes = ImmutableList.builder();
        List<DecimalStreamCheckpoint> dataCheckpoints = this.dataStream.getCheckpoints();
        List scaleCheckpoints = this.scaleStream.getCheckpoints();
        Optional<List<BooleanStreamCheckpoint>> presentCheckpoints = this.presentStream.getCheckpoints();
        int i = 0;
        while (i < this.rowGroupColumnStatistics.size()) {
            int groupId = i++;
            ColumnStatistics columnStatistics = this.rowGroupColumnStatistics.get(groupId);
            DecimalStreamCheckpoint dataCheckpoint = dataCheckpoints.get(groupId);
            LongStreamCheckpoint scaleCheckpoint = (LongStreamCheckpoint)scaleCheckpoints.get(groupId);
            Optional<BooleanStreamCheckpoint> presentCheckpoint = presentCheckpoints.map(checkpoints -> (BooleanStreamCheckpoint)checkpoints.get(groupId));
            List<Integer> positions = DecimalColumnWriter.createDecimalColumnPositionList(this.compressed, dataCheckpoint, scaleCheckpoint, presentCheckpoint);
            rowGroupIndexes.add((Object)new RowGroupIndex(positions, columnStatistics));
        }
        Slice slice = this.metadataWriter.writeRowIndexes((List<RowGroupIndex>)rowGroupIndexes.build());
        Stream stream = new Stream(this.column, Stream.StreamKind.ROW_INDEX, slice.length(), false);
        return ImmutableList.of((Object)new StreamDataOutput(slice, stream));
    }

    private static List<Integer> createDecimalColumnPositionList(boolean compressed, DecimalStreamCheckpoint dataCheckpoint, LongStreamCheckpoint scaleCheckpoint, Optional<BooleanStreamCheckpoint> presentCheckpoint) {
        ImmutableList.Builder positionList = ImmutableList.builder();
        presentCheckpoint.ifPresent(booleanStreamCheckpoint -> positionList.addAll(booleanStreamCheckpoint.toPositionList(compressed)));
        positionList.addAll(dataCheckpoint.toPositionList(compressed));
        positionList.addAll(scaleCheckpoint.toPositionList(compressed));
        return positionList.build();
    }

    @Override
    public List<StreamDataOutput> getDataStreams() {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        this.presentStream.getStreamDataOutput(this.column).ifPresent(arg_0 -> ((ImmutableList.Builder)outputDataStreams).add(arg_0));
        outputDataStreams.add((Object)this.dataStream.getStreamDataOutput(this.column));
        outputDataStreams.add((Object)this.scaleStream.getStreamDataOutput(this.column));
        return outputDataStreams.build();
    }

    @Override
    public long getBufferedBytes() {
        return this.dataStream.getBufferedBytes() + this.scaleStream.getBufferedBytes() + this.presentStream.getBufferedBytes();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.dataStream.getRetainedBytes() + this.scaleStream.getRetainedBytes() + this.presentStream.getRetainedBytes() + this.columnStatisticsRetainedSizeInBytes;
    }

    @Override
    public void reset() {
        this.closed = false;
        this.dataStream.reset();
        this.scaleStream.reset();
        this.presentStream.reset();
        this.rowGroupColumnStatistics.clear();
        this.columnStatisticsRetainedSizeInBytes = 0L;
        this.shortDecimalStatisticsBuilder = new ShortDecimalStatisticsBuilder(this.type.getScale());
        this.longDecimalStatisticsBuilder = new LongDecimalStatisticsBuilder();
    }
}

