/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.writer.DictionaryRowGroup;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

class DictionaryRowGroupBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DictionaryRowGroupBuilder.class).instanceSize();
    private byte[][] byteSegments;
    private int byteSegmentOffset;
    private short[][] shortSegments;
    private int shortSegmentOffset;
    private int[][] integerSegments;
    private int integerSegmentOffset;
    private int indexRetainedBytes;
    private int lastMaxIndex = -1;

    DictionaryRowGroupBuilder() {
    }

    private static int calculateNewLength(int expectedLength, int currentLength) {
        return Math.max(expectedLength + 1, (int)((double)currentLength * 1.5));
    }

    private void appendByteIndexes(byte[] byteIndexes) {
        this.indexRetainedBytes = (int)((long)this.indexRetainedBytes + SizeOf.sizeOf((byte[])byteIndexes));
        if (this.byteSegments == null) {
            this.byteSegments = new byte[1][];
        } else if (this.byteSegmentOffset >= this.byteSegments.length) {
            this.byteSegments = (byte[][])Arrays.copyOf(this.byteSegments, DictionaryRowGroupBuilder.calculateNewLength(this.byteSegmentOffset, this.byteSegments.length));
        }
        this.byteSegments[this.byteSegmentOffset++] = byteIndexes;
    }

    private void appendShortIndexes(short[] shortIndexes) {
        this.indexRetainedBytes = (int)((long)this.indexRetainedBytes + SizeOf.sizeOf((short[])shortIndexes));
        if (this.shortSegments == null) {
            this.shortSegments = new short[1][];
        } else if (this.shortSegmentOffset >= this.shortSegments.length) {
            this.shortSegments = (short[][])Arrays.copyOf(this.shortSegments, DictionaryRowGroupBuilder.calculateNewLength(this.shortSegmentOffset, this.shortSegments.length));
        }
        this.shortSegments[this.shortSegmentOffset++] = shortIndexes;
    }

    private void appendIntegerIndexes(int[] intIndexes) {
        this.indexRetainedBytes = (int)((long)this.indexRetainedBytes + SizeOf.sizeOf((int[])intIndexes));
        if (this.integerSegments == null) {
            this.integerSegments = new int[1][];
        } else if (this.integerSegmentOffset >= this.integerSegments.length) {
            this.integerSegments = (int[][])Arrays.copyOf(this.integerSegments, DictionaryRowGroupBuilder.calculateNewLength(this.integerSegmentOffset, this.integerSegments.length));
        }
        this.integerSegments[this.integerSegmentOffset++] = intIndexes;
    }

    public void addIndexes(int maxIndex, int[] dictionaryIndexes, int indexCount) {
        if (indexCount == 0 && this.indexRetainedBytes > 0) {
            return;
        }
        Preconditions.checkState((maxIndex >= this.lastMaxIndex ? 1 : 0) != 0, (Object)"LastMax is greater than the current max");
        this.lastMaxIndex = maxIndex;
        if (maxIndex <= 127) {
            byte[] byteIndexes = new byte[indexCount];
            for (int i = 0; i < indexCount; ++i) {
                byteIndexes[i] = (byte)dictionaryIndexes[i];
            }
            this.appendByteIndexes(byteIndexes);
        } else if (maxIndex <= Short.MAX_VALUE) {
            short[] shortIndexes = new short[indexCount];
            for (int i = 0; i < indexCount; ++i) {
                shortIndexes[i] = (short)dictionaryIndexes[i];
            }
            this.appendShortIndexes(shortIndexes);
        } else {
            int[] intIndexes = Arrays.copyOf(dictionaryIndexes, indexCount);
            this.appendIntegerIndexes(intIndexes);
        }
    }

    public DictionaryRowGroup build(ColumnStatistics columnStatistics) {
        return new DictionaryRowGroup(this.getByteSegments(), this.getShortSegments(), this.getIntegerSegments(), columnStatistics);
    }

    private static <T> T[] truncateToLength(T[] original, int newLength) {
        if (original == null) {
            return null;
        }
        if (original.length == newLength) {
            return original;
        }
        return Arrays.copyOf(original, newLength);
    }

    @Nullable
    public byte[][] getByteSegments() {
        return (byte[][])DictionaryRowGroupBuilder.truncateToLength(this.byteSegments, this.byteSegmentOffset);
    }

    @Nullable
    public short[][] getShortSegments() {
        return (short[][])DictionaryRowGroupBuilder.truncateToLength(this.shortSegments, this.shortSegmentOffset);
    }

    @Nullable
    public int[][] getIntegerSegments() {
        return (int[][])DictionaryRowGroupBuilder.truncateToLength(this.integerSegments, this.integerSegmentOffset);
    }

    public int getIndexRetainedBytes() {
        return this.indexRetainedBytes;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.byteSegments) + SizeOf.sizeOf((Object[])this.shortSegments) + SizeOf.sizeOf((Object[])this.integerSegments) + (long)this.indexRetainedBytes;
    }

    public void reset() {
        this.byteSegments = null;
        this.byteSegmentOffset = 0;
        this.shortSegments = null;
        this.shortSegmentOffset = 0;
        this.integerSegments = null;
        this.integerSegmentOffset = 0;
        this.indexRetainedBytes = 0;
        this.lastMaxIndex = -1;
    }
}

