/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.alluxio;

import alluxio.ClientContext;
import alluxio.client.table.RetryHandlingTableMasterClient;
import alluxio.client.table.TableMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.master.MasterClientContext;
import alluxio.util.ConfigurationUtils;
import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.alluxio.AlluxioHiveMetastore;
import com.facebook.presto.hive.metastore.alluxio.AlluxioHiveMetastoreConfig;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.ExportBinder;

public class AlluxioMetastoreModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(AlluxioHiveMetastoreConfig.class);
        binder.bind(ExtendedHiveMetastore.class).to(AlluxioHiveMetastore.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ExtendedHiveMetastore.class).as(ObjectNames.generatedNameOf(AlluxioHiveMetastore.class));
    }

    @Provides
    @Inject
    TableMasterClient provideCatalogMasterClient(AlluxioHiveMetastoreConfig config) {
        InstancedConfiguration conf = new InstancedConfiguration(ConfigurationUtils.defaults());
        if (config.isZookeeperEnabled()) {
            conf.set(PropertyKey.ZOOKEEPER_ENABLED, (Object)true);
            conf.set(PropertyKey.ZOOKEEPER_ADDRESS, (Object)config.getZookeeperAddress());
        } else {
            String address = config.getMasterAddress();
            String[] parts = address.split(":", 2);
            conf.set(PropertyKey.MASTER_HOSTNAME, (Object)parts[0]);
            if (parts.length > 1) {
                conf.set(PropertyKey.MASTER_RPC_PORT, (Object)parts[1]);
            }
        }
        MasterClientContext context = MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)conf)).build();
        return new RetryHandlingTableMasterClient(context);
    }
}

