/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.glue;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.handlers.AsyncHandler;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.airlift.stats.TimeStat;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class GlueCatalogApiStats {
    private final TimeStat time = new TimeStat(TimeUnit.MILLISECONDS);
    private final CounterStat totalFailures = new CounterStat();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T record(Supplier<T> action) {
        try (TimeStat.BlockTimer timer = this.time.time();){
            T t = action.get();
            return t;
        }
        catch (Exception e) {
            this.recordException(e);
            throw e;
        }
    }

    public void record(Runnable action) {
        try (TimeStat.BlockTimer timer = this.time.time();){
            action.run();
        }
        catch (Exception e) {
            this.recordException(e);
            throw e;
        }
    }

    public <R extends AmazonWebServiceRequest, T> AsyncHandler<R, T> metricsAsyncHandler() {
        return new AsyncHandler<R, T>(){
            private final TimeStat.BlockTimer timer;
            {
                this.timer = GlueCatalogApiStats.this.time.time();
            }

            public void onError(Exception exception) {
                this.timer.close();
                GlueCatalogApiStats.this.recordException(exception);
            }

            public void onSuccess(R request, T result) {
                this.timer.close();
            }
        };
    }

    @Managed
    @Nested
    public TimeStat getTime() {
        return this.time;
    }

    @Managed
    @Nested
    public CounterStat getTotalFailures() {
        return this.totalFailures;
    }

    private void recordException(Exception e) {
        this.totalFailures.update(1L);
    }
}

