/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.OrcUnion;
import com.facebook.hive.orc.RunLengthByteReader;
import com.facebook.hive.orc.StreamName;
import com.facebook.hive.orc.lazy.LazyTreeReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class LazyUnionTreeReader
extends LazyTreeReader {
    private final LazyTreeReader[] fields;
    private RunLengthByteReader tags;

    public LazyUnionTreeReader(int columnId, long rowIndexStride, LazyTreeReader[] fields) {
        super(columnId, rowIndexStride);
        this.fields = fields;
    }

    @Override
    public Object next(Object previous) throws IOException {
        OrcUnion result = null;
        if (this.valuePresent) {
            result = previous == null ? new OrcUnion() : (OrcUnion)previous;
            byte tag = this.nextTag();
            Object previousVal = result.getObject();
            result.set(tag, this.fields[tag].getInComplexType(tag == result.getTag() ? previousVal : null, this.previousRow));
        }
        return result;
    }

    @Override
    protected void seek(int rowIndexEntry, boolean backwards) throws IOException {
        super.seek(rowIndexEntry, backwards);
        for (LazyTreeReader field : this.fields) {
            field.seek(rowIndexEntry, backwards);
        }
    }

    @Override
    public void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings, OrcProto.RowIndex[] indexes, long rowBaseInStripe) throws IOException {
        super.startStripe(streams, encodings, indexes, rowBaseInStripe);
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].startStripe(streams, encodings, indexes, rowBaseInStripe);
        }
        this.tags = new RunLengthByteReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)));
        if (indexes[this.columnId] != null) {
            this.loadIndeces(indexes[this.columnId].getEntryList(), 0);
        }
    }

    @Override
    public void seek(int index) throws IOException {
        this.tags.seek(index);
    }

    @Override
    public int loadIndeces(List<OrcProto.RowIndexEntry> rowIndexEntries, int startIndex) {
        int updatedStartIndex = super.loadIndeces(rowIndexEntries, startIndex);
        return this.tags.loadIndeces(rowIndexEntries, updatedStartIndex);
    }

    public byte nextTag() throws IOException {
        return this.tags.next();
    }

    @Override
    public void skipRows(long numNonNullValues) throws IOException {
        long[] counts = new long[this.fields.length];
        int i = 0;
        while ((long)i < numNonNullValues) {
            byte by = this.tags.next();
            counts[by] = counts[by] + 1L;
            ++i;
        }
        for (i = 0; i < counts.length; ++i) {
            this.fields[i].skipRowsInComplexType(counts[i]);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        for (LazyTreeReader field : this.fields) {
            field.close();
        }
        if (this.tags != null) {
            this.tags.close();
        }
    }
}

