/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;

public class SerializableConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Configuration configuration;

    public SerializableConfiguration(Configuration configuration) {
        this.configuration = new Configuration(configuration);
    }

    public SerializableConfiguration(SerializableConfiguration configuration) {
        this.configuration = configuration.newCopy();
    }

    public Configuration newCopy() {
        return new Configuration(this.configuration);
    }

    public Configuration get() {
        return this.configuration;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.configuration.write((DataOutput)out);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.configuration = new Configuration(false);
        this.configuration.readFields((DataInput)in);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        this.configuration.iterator().forEachRemaining(e -> str.append(String.format("%s => %s \n", e.getKey(), e.getValue())));
        return this.configuration.toString();
    }
}

