/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class BootstrapColumnStichingRecordReader
implements RecordReader<NullWritable, ArrayWritable> {
    private static final Logger LOG = LogManager.getLogger(BootstrapColumnStichingRecordReader.class);
    private final RecordReader<NullWritable, ArrayWritable> leftColsRecordReader;
    private final RecordReader<NullWritable, ArrayWritable> rightColsRecordReader;
    private final int numLeftColumns;
    private final ArrayWritable values;
    private final boolean validate;

    public BootstrapColumnStichingRecordReader(RecordReader<NullWritable, ArrayWritable> left, int numLeftColumns, RecordReader<NullWritable, ArrayWritable> right, int numRightColumns, boolean validate) {
        this.leftColsRecordReader = left;
        this.rightColsRecordReader = right;
        this.validate = validate;
        this.numLeftColumns = numLeftColumns;
        ArrayWritable rightW = (ArrayWritable)this.rightColsRecordReader.createValue();
        int numColumns = numLeftColumns + numRightColumns;
        if (rightW.getValueClass() != null) {
            this.values = new ArrayWritable(rightW.getValueClass(), new Writable[numColumns]);
        } else {
            String[] vals = IntStream.range(0, numColumns).mapToObj(idx -> "").collect(Collectors.toList()).toArray(new String[0]);
            this.values = new ArrayWritable(vals);
        }
        LOG.info((Object)("Total ArrayWritable Length :" + this.values.get().length));
    }

    public boolean next(NullWritable key, ArrayWritable value) throws IOException {
        ArrayWritable left = (ArrayWritable)this.leftColsRecordReader.createValue();
        ArrayWritable right = (ArrayWritable)this.rightColsRecordReader.createValue();
        boolean hasMoreOnLeft = this.leftColsRecordReader.next(this.leftColsRecordReader.createKey(), (Object)left);
        boolean hasMoreOnRight = this.rightColsRecordReader.next(this.rightColsRecordReader.createKey(), (Object)right);
        if (this.validate) {
            ValidationUtils.checkArgument(hasMoreOnLeft == hasMoreOnRight, String.format("hasMoreOnLeft:%s, hasMoreOnRight: %s", hasMoreOnLeft, hasMoreOnRight));
        }
        for (int i = 0; i < this.numLeftColumns; ++i) {
            value.get()[i] = left.get()[i];
        }
        for (int j = this.numLeftColumns; j < right.get().length; ++j) {
            value.get()[j] = right.get()[j];
        }
        return hasMoreOnLeft && hasMoreOnRight;
    }

    public NullWritable createKey() {
        return (NullWritable)this.leftColsRecordReader.createKey();
    }

    public ArrayWritable createValue() {
        return this.values;
    }

    public long getPos() throws IOException {
        return this.leftColsRecordReader.getPos();
    }

    public void close() throws IOException {
        this.leftColsRecordReader.close();
        this.rightColsRecordReader.close();
    }

    public float getProgress() throws IOException {
        return this.leftColsRecordReader.getProgress();
    }
}

