/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;

public class HoodieHFileReader<R extends IndexedRecord>
implements HoodieFileReader {
    private Path path;
    private Configuration conf;
    private HFile.Reader reader;
    private FSDataInputStream fsDataInputStream;
    private Schema schema;
    private HFileScanner keyScanner;
    public static final String KEY_SCHEMA = "schema";
    public static final String KEY_BLOOM_FILTER_META_BLOCK = "bloomFilter";
    public static final String KEY_BLOOM_FILTER_TYPE_CODE = "bloomFilterTypeCode";
    public static final String KEY_MIN_RECORD = "minRecordKey";
    public static final String KEY_MAX_RECORD = "maxRecordKey";

    public HoodieHFileReader(Configuration configuration, Path path, CacheConfig cacheConfig) throws IOException {
        this.conf = configuration;
        this.path = path;
        this.reader = HFile.createReader(FSUtils.getFs(path.toString(), configuration), path, cacheConfig, this.conf);
    }

    public HoodieHFileReader(Configuration configuration, Path path, CacheConfig cacheConfig, FileSystem inlineFs) throws IOException {
        this.conf = configuration;
        this.path = path;
        this.fsDataInputStream = inlineFs.open(path);
        this.reader = HFile.createReader(inlineFs, path, cacheConfig, configuration);
    }

    public HoodieHFileReader(byte[] content) throws IOException {
        Configuration conf = new Configuration();
        Path path = new Path("hoodie");
        SeekableByteArrayInputStream bis = new SeekableByteArrayInputStream(content);
        FSDataInputStream fsdis = new FSDataInputStream((InputStream)bis);
        this.reader = HFile.createReader(FSUtils.getFs("hoodie", conf), path, new FSDataInputStreamWrapper(fsdis), content.length, new CacheConfig(conf), conf);
    }

    @Override
    public String[] readMinMaxRecordKeys() {
        try {
            Map<byte[], byte[]> fileInfo = this.reader.loadFileInfo();
            return new String[]{new String(fileInfo.get(KEY_MIN_RECORD.getBytes())), new String(fileInfo.get(KEY_MAX_RECORD.getBytes()))};
        }
        catch (IOException e) {
            throw new HoodieException("Could not read min/max record key out of file information block correctly from path", e);
        }
    }

    @Override
    public Schema getSchema() {
        if (this.schema == null) {
            try {
                Map<byte[], byte[]> fileInfo = this.reader.loadFileInfo();
                this.schema = new Schema.Parser().parse(new String(fileInfo.get(KEY_SCHEMA.getBytes())));
            }
            catch (IOException e) {
                throw new HoodieException("Could not read schema of file from path", e);
            }
        }
        return this.schema;
    }

    @Override
    public BloomFilter readBloomFilter() {
        try {
            Map<byte[], byte[]> fileInfo = this.reader.loadFileInfo();
            ByteBuffer serializedFilter = this.reader.getMetaBlock(KEY_BLOOM_FILTER_META_BLOCK, false);
            byte[] filterBytes = new byte[serializedFilter.remaining()];
            serializedFilter.get(filterBytes);
            return BloomFilterFactory.fromString(new String(filterBytes), new String(fileInfo.get(KEY_BLOOM_FILTER_TYPE_CODE.getBytes())));
        }
        catch (IOException e) {
            throw new HoodieException("Could not read bloom filter from " + this.path, e);
        }
    }

    public Set<String> filterRowKeys(Set candidateRowKeys) {
        try {
            List<Pair<String, R>> allRecords = this.readAllRecords();
            HashSet<String> rowKeys = new HashSet<String>();
            allRecords.forEach(t -> {
                if (candidateRowKeys.contains(t.getFirst())) {
                    rowKeys.add((String)t.getFirst());
                }
            });
            return rowKeys;
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read row keys from " + this.path, e);
        }
    }

    public List<Pair<String, R>> readAllRecords(Schema writerSchema, Schema readerSchema) throws IOException {
        LinkedList<Pair<String, R>> recordList = new LinkedList<Pair<String, R>>();
        try {
            HFileScanner scanner = this.reader.getScanner(false, false);
            if (scanner.seekTo()) {
                do {
                    Cell c = scanner.getKeyValue();
                    byte[] keyBytes = Arrays.copyOfRange(c.getRowArray(), c.getRowOffset(), c.getRowOffset() + c.getRowLength());
                    R record = this.getRecordFromCell(c, writerSchema, readerSchema);
                    recordList.add(new Pair<String, R>(new String(keyBytes), record));
                } while (scanner.next());
            }
            return recordList;
        }
        catch (IOException e) {
            throw new HoodieException("Error reading hfile " + this.path + " as a dataframe", e);
        }
    }

    public List<Pair<String, R>> readAllRecords() throws IOException {
        Schema schema = new Schema.Parser().parse(new String(this.reader.loadFileInfo().get(KEY_SCHEMA.getBytes())));
        return this.readAllRecords(schema, schema);
    }

    public List<Pair<String, R>> readRecords(List<String> keys) throws IOException {
        this.reader.loadFileInfo();
        Schema schema = new Schema.Parser().parse(new String(this.reader.loadFileInfo().get(KEY_SCHEMA.getBytes())));
        return this.readRecords(keys, schema);
    }

    public List<Pair<String, R>> readRecords(List<String> keys, Schema schema) throws IOException {
        this.schema = schema;
        this.reader.loadFileInfo();
        ArrayList<Pair<String, R>> records = new ArrayList<Pair<String, R>>();
        for (String key : keys) {
            Option value = this.getRecordByKey(key, schema);
            if (!value.isPresent()) continue;
            records.add(new Pair(key, value.get()));
        }
        return records;
    }

    public Iterator getRecordIterator(final Schema readerSchema) throws IOException {
        final HFileScanner scanner = this.reader.getScanner(false, false);
        return new Iterator<R>(){
            private R next = null;
            private boolean eof = false;

            @Override
            public boolean hasNext() {
                try {
                    if (this.next == null && !this.eof && !scanner.isSeeked() && scanner.seekTo()) {
                        this.next = HoodieHFileReader.this.getRecordFromCell(scanner.getKeyValue(), HoodieHFileReader.this.getSchema(), readerSchema);
                    }
                    return this.next != null;
                }
                catch (IOException io) {
                    throw new HoodieIOException("unable to read next record from hfile ", io);
                }
            }

            @Override
            public R next() {
                try {
                    if (this.next == null && !this.hasNext()) {
                        throw new HoodieIOException("No more records left to read from hfile");
                    }
                    Object retVal = this.next;
                    if (scanner.next()) {
                        this.next = HoodieHFileReader.this.getRecordFromCell(scanner.getKeyValue(), HoodieHFileReader.this.getSchema(), readerSchema);
                    } else {
                        this.next = null;
                        this.eof = true;
                    }
                    return retVal;
                }
                catch (IOException io) {
                    throw new HoodieIOException("unable to read next record from parquet file ", io);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Option getRecordByKey(String key, Schema readerSchema) throws IOException {
        byte[] value = null;
        KeyValue kv = new KeyValue(key.getBytes(), null, null, null);
        HoodieHFileReader hoodieHFileReader = this;
        synchronized (hoodieHFileReader) {
            if (this.keyScanner == null) {
                this.keyScanner = this.reader.getScanner(false, false);
            }
            if (this.keyScanner.seekTo(kv) == 0) {
                Cell c = this.keyScanner.getKeyValue();
                value = Arrays.copyOfRange(c.getValueArray(), c.getValueOffset(), c.getValueOffset() + c.getValueLength());
            }
        }
        if (value != null) {
            GenericRecord record = HoodieAvroUtils.bytesToAvro(value, this.getSchema(), readerSchema);
            return Option.of(record);
        }
        return Option.empty();
    }

    private R getRecordFromCell(Cell c, Schema writerSchema, Schema readerSchema) throws IOException {
        byte[] value = Arrays.copyOfRange(c.getValueArray(), c.getValueOffset(), c.getValueOffset() + c.getValueLength());
        return (R)HoodieAvroUtils.bytesToAvro(value, writerSchema, readerSchema);
    }

    @Override
    public long getTotalRecords() {
        return this.reader.getEntries();
    }

    @Override
    public synchronized void close() {
        try {
            this.reader.close();
            this.reader = null;
            if (this.fsDataInputStream != null) {
                this.fsDataInputStream.close();
            }
            this.keyScanner = null;
        }
        catch (IOException e) {
            throw new HoodieIOException("Error closing the hfile reader", e);
        }
    }

    static class SeekableByteArrayInputStream
    extends ByteArrayInputStream
    implements Seekable,
    PositionedReadable {
        public SeekableByteArrayInputStream(byte[] buf) {
            super(buf);
        }

        public long getPos() throws IOException {
            return this.pos;
        }

        public void seek(long pos) throws IOException {
            if (this.mark != 0) {
                throw new IllegalStateException();
            }
            this.reset();
            long skipped = this.skip(pos);
            if (skipped != pos) {
                throw new IOException();
            }
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            if (position >= (long)this.buf.length) {
                throw new IllegalArgumentException();
            }
            if (position + (long)length > (long)this.buf.length) {
                throw new IllegalArgumentException();
            }
            if (length > buffer.length) {
                throw new IllegalArgumentException();
            }
            System.arraycopy(this.buf, (int)position, buffer, offset, length);
            return length;
        }

        public void readFully(long position, byte[] buffer) throws IOException {
            this.read(position, buffer, 0, buffer.length);
        }

        public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
            this.read(position, buffer, offset, length);
        }
    }
}

