/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hudi.org.apache.hadoop.hbase.ResourceChecker;
import org.apache.hudi.org.apache.hadoop.hbase.util.JVM;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;

public class ResourceCheckerJUnitListener
extends RunListener {
    private Map<String, ResourceChecker> rcs = new ConcurrentHashMap<String, ResourceChecker>();

    protected void addResourceAnalyzer(ResourceChecker rc) {
    }

    private void start(String testName) {
        ResourceChecker rc = new ResourceChecker(testName);
        rc.addResourceAnalyzer(new ThreadResourceAnalyzer());
        rc.addResourceAnalyzer(new OpenFileDescriptorResourceAnalyzer());
        rc.addResourceAnalyzer(new MaxFileDescriptorResourceAnalyzer());
        rc.addResourceAnalyzer(new SystemLoadAverageResourceAnalyzer());
        rc.addResourceAnalyzer(new ProcessCountResourceAnalyzer());
        rc.addResourceAnalyzer(new AvailableMemoryMBResourceAnalyzer());
        this.addResourceAnalyzer(rc);
        this.rcs.put(testName, rc);
        rc.start();
    }

    private void end(String testName) {
        ResourceChecker rc = this.rcs.remove(testName);
        assert (rc != null);
        rc.end();
    }

    private String descriptionToShortTestName(Description description) {
        int toRemove = "org.apache.hudi.org.apache.hadoop.hbase.".length();
        return description.getTestClass().getName().substring(toRemove) + "#" + description.getMethodName();
    }

    public void testStarted(Description description) throws Exception {
        this.start(this.descriptionToShortTestName(description));
    }

    public void testFinished(Description description) throws Exception {
        this.end(this.descriptionToShortTestName(description));
    }

    static class AvailableMemoryMBResourceAnalyzer
    extends ResourceChecker.ResourceAnalyzer {
        AvailableMemoryMBResourceAnalyzer() {
        }

        @Override
        public int getVal(ResourceChecker.Phase phase) {
            if (!JVM.isUnix()) {
                return 0;
            }
            return (int)(new JVM().getFreeMemory() / 0x100000L);
        }
    }

    static class ProcessCountResourceAnalyzer
    extends ResourceChecker.ResourceAnalyzer {
        ProcessCountResourceAnalyzer() {
        }

        @Override
        public int getVal(ResourceChecker.Phase phase) {
            if (!JVM.isUnix()) {
                return 0;
            }
            return new JVM().getNumberOfRunningProcess();
        }
    }

    static class SystemLoadAverageResourceAnalyzer
    extends ResourceChecker.ResourceAnalyzer {
        SystemLoadAverageResourceAnalyzer() {
        }

        @Override
        public int getVal(ResourceChecker.Phase phase) {
            if (!JVM.isUnix()) {
                return 0;
            }
            return (int)(new JVM().getSystemLoadAverage() * 100.0);
        }
    }

    static class MaxFileDescriptorResourceAnalyzer
    extends ResourceChecker.ResourceAnalyzer {
        MaxFileDescriptorResourceAnalyzer() {
        }

        @Override
        public int getVal(ResourceChecker.Phase phase) {
            if (!JVM.isUnix()) {
                return 0;
            }
            JVM jvm = new JVM();
            return (int)jvm.getMaxFileDescriptorCount();
        }
    }

    static class OpenFileDescriptorResourceAnalyzer
    extends ResourceChecker.ResourceAnalyzer {
        OpenFileDescriptorResourceAnalyzer() {
        }

        @Override
        public int getVal(ResourceChecker.Phase phase) {
            if (!JVM.isUnix()) {
                return 0;
            }
            JVM jvm = new JVM();
            return (int)jvm.getOpenFileDescriptorCount();
        }

        @Override
        public int getMax() {
            return 1024;
        }
    }

    static class ThreadResourceAnalyzer
    extends ResourceChecker.ResourceAnalyzer {
        private static Set<String> initialThreadNames = new HashSet<String>();
        private static List<String> stringsToLog = null;

        ThreadResourceAnalyzer() {
        }

        @Override
        public int getVal(ResourceChecker.Phase phase) {
            Map<Thread, StackTraceElement[]> stackTraces;
            block4: {
                block3: {
                    stackTraces = Thread.getAllStackTraces();
                    if (phase != ResourceChecker.Phase.INITIAL) break block3;
                    stringsToLog = null;
                    for (Thread t : stackTraces.keySet()) {
                        initialThreadNames.add(t.getName());
                    }
                    break block4;
                }
                if (phase != ResourceChecker.Phase.END || stackTraces.size() <= initialThreadNames.size()) break block4;
                stringsToLog = new ArrayList<String>();
                for (Thread t : stackTraces.keySet()) {
                    StackTraceElement[] stackElements;
                    if (initialThreadNames.contains(t.getName())) continue;
                    stringsToLog.add("\nPotentially hanging thread: " + t.getName() + "\n");
                    for (StackTraceElement ele : stackElements = stackTraces.get(t)) {
                        stringsToLog.add("\t" + ele + "\n");
                    }
                }
            }
            return stackTraces.size();
        }

        @Override
        public int getMax() {
            return 500;
        }

        @Override
        public List<String> getStringsToLog() {
            return stringsToLog;
        }
    }
}

