/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class RetriesExhaustedException
extends IOException {
    private static final long serialVersionUID = 1876775844L;

    public RetriesExhaustedException(String msg) {
        super(msg);
    }

    public RetriesExhaustedException(String msg, IOException e) {
        super(msg, e);
    }

    public RetriesExhaustedException(String callableVitals, int numTries, List<Throwable> exceptions) {
        super(RetriesExhaustedException.getMessage(callableVitals, numTries, exceptions));
    }

    @InterfaceAudience.Private
    public RetriesExhaustedException(int numTries, List<ThrowableWithExtraContext> exceptions) {
        super(RetriesExhaustedException.getMessage(numTries, exceptions), exceptions.isEmpty() ? null : exceptions.get(exceptions.size() - 1).t);
    }

    private static String getMessage(String callableVitals, int numTries, List<Throwable> exceptions) {
        StringBuilder buffer = new StringBuilder("Failed contacting ");
        buffer.append(callableVitals);
        buffer.append(" after ");
        buffer.append(numTries + 1);
        buffer.append(" attempts.\nExceptions:\n");
        for (Throwable t : exceptions) {
            buffer.append(t.toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private static String getMessage(int numTries, List<ThrowableWithExtraContext> exceptions) {
        StringBuilder buffer = new StringBuilder("Failed after attempts=");
        buffer.append(numTries + 1);
        buffer.append(", exceptions:\n");
        for (ThrowableWithExtraContext t : exceptions) {
            buffer.append(t.toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    @InterfaceAudience.Private
    public static class ThrowableWithExtraContext {
        private final Throwable t;
        private final long when;
        private final String extras;

        public ThrowableWithExtraContext(Throwable t, long when, String extras) {
            this.t = t;
            this.when = when;
            this.extras = extras;
        }

        public String toString() {
            return new Date(this.when).toString() + ", " + this.extras + ", " + this.t.toString();
        }
    }
}

