/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client.security;

import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public enum SecurityCapability {
    SIMPLE_AUTHENTICATION(0),
    SECURE_AUTHENTICATION(1),
    AUTHORIZATION(2),
    CELL_AUTHORIZATION(3),
    CELL_VISIBILITY(4);

    private int value;

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.toString();
    }

    private SecurityCapability(int value) {
        this.value = value;
    }

    public static SecurityCapability valueOf(int value) {
        switch (value) {
            case 0: {
                return SIMPLE_AUTHENTICATION;
            }
            case 1: {
                return SECURE_AUTHENTICATION;
            }
            case 2: {
                return AUTHORIZATION;
            }
            case 3: {
                return CELL_AUTHORIZATION;
            }
            case 4: {
                return CELL_VISIBILITY;
            }
        }
        throw new IllegalArgumentException("Unknown SecurityCapability value " + value);
    }
}

