/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.codec.BaseDecoder;
import org.apache.hudi.org.apache.hadoop.hbase.codec.BaseEncoder;
import org.apache.hudi.org.apache.hadoop.hbase.codec.Codec;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.CellProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.ByteStringer;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class MessageCodec
implements Codec {
    @Override
    public Codec.Decoder getDecoder(InputStream is) {
        return new MessageDecoder(is);
    }

    @Override
    public Codec.Encoder getEncoder(OutputStream os) {
        return new MessageEncoder(os);
    }

    static class MessageDecoder
    extends BaseDecoder {
        MessageDecoder(InputStream in) {
            super(in);
        }

        @Override
        protected Cell parseCell() throws IOException {
            CellProtos.Cell pbcell = CellProtos.Cell.parseDelimitedFrom(this.in);
            return CellUtil.createCell(pbcell.getRow().toByteArray(), pbcell.getFamily().toByteArray(), pbcell.getQualifier().toByteArray(), pbcell.getTimestamp(), (byte)pbcell.getCellType().getNumber(), pbcell.getValue().toByteArray());
        }
    }

    static class MessageEncoder
    extends BaseEncoder {
        MessageEncoder(OutputStream out) {
            super(out);
        }

        @Override
        public void write(Cell cell) throws IOException {
            this.checkFlushed();
            CellProtos.Cell.Builder builder = CellProtos.Cell.newBuilder();
            builder.setRow(ByteStringer.wrap(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength()));
            builder.setFamily(ByteStringer.wrap(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength()));
            builder.setQualifier(ByteStringer.wrap(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()));
            builder.setTimestamp(cell.getTimestamp());
            builder.setCellType(CellProtos.CellType.valueOf(cell.getTypeByte()));
            builder.setValue(ByteStringer.wrap(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
            CellProtos.Cell pbcell = builder.build();
            pbcell.writeDelimitedTo(this.out);
        }
    }
}

