/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.hudi.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hudi.org.apache.hadoop.hbase.filter.Filter;
import org.apache.hudi.org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hudi.org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class MultipleColumnPrefixFilter
extends FilterBase {
    protected byte[] hint = null;
    protected TreeSet<byte[]> sortedPrefixes = this.createTreeSet();
    private static final int MAX_LOG_PREFIXES = 5;

    public MultipleColumnPrefixFilter(byte[][] prefixes) {
        if (prefixes != null) {
            for (int i = 0; i < prefixes.length; ++i) {
                if (this.sortedPrefixes.add(prefixes[i])) continue;
                throw new IllegalArgumentException("prefixes must be distinct");
            }
        }
    }

    public byte[][] getPrefix() {
        int count = 0;
        byte[][] temp = new byte[this.sortedPrefixes.size()][];
        for (byte[] prefixes : this.sortedPrefixes) {
            temp[count++] = prefixes;
        }
        return temp;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell kv) {
        if (this.sortedPrefixes.size() == 0 || kv.getQualifierArray() == null) {
            return Filter.ReturnCode.INCLUDE;
        }
        return this.filterColumn(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength());
    }

    @Override
    public Cell transformCell(Cell v) {
        return v;
    }

    public Filter.ReturnCode filterColumn(byte[] buffer, int qualifierOffset, int qualifierLength) {
        byte[] qualifier = Arrays.copyOfRange(buffer, qualifierOffset, qualifierLength + qualifierOffset);
        TreeSet lesserOrEqualPrefixes = (TreeSet)this.sortedPrefixes.headSet(qualifier, true);
        if (lesserOrEqualPrefixes.size() != 0) {
            byte[] largestPrefixSmallerThanQualifier = (byte[])lesserOrEqualPrefixes.last();
            if (Bytes.startsWith(qualifier, largestPrefixSmallerThanQualifier)) {
                return Filter.ReturnCode.INCLUDE;
            }
            if (lesserOrEqualPrefixes.size() == this.sortedPrefixes.size()) {
                return Filter.ReturnCode.NEXT_ROW;
            }
            this.hint = this.sortedPrefixes.higher(largestPrefixSmallerThanQualifier);
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        this.hint = this.sortedPrefixes.first();
        return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        byte[][] prefixes = new byte[filterArguments.size()][];
        for (int i = 0; i < filterArguments.size(); ++i) {
            byte[] columnPrefix = ParseFilter.removeQuotesFromByteArray(filterArguments.get(i));
            prefixes[i] = columnPrefix;
        }
        return new MultipleColumnPrefixFilter(prefixes);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.MultipleColumnPrefixFilter.Builder builder = FilterProtos.MultipleColumnPrefixFilter.newBuilder();
        for (byte[] element : this.sortedPrefixes) {
            if (element == null) continue;
            builder.addSortedPrefixes(ByteStringer.wrap(element));
        }
        return builder.build().toByteArray();
    }

    public static MultipleColumnPrefixFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.MultipleColumnPrefixFilter proto;
        try {
            proto = FilterProtos.MultipleColumnPrefixFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        int numPrefixes = proto.getSortedPrefixesCount();
        byte[][] prefixes = new byte[numPrefixes][];
        for (int i = 0; i < numPrefixes; ++i) {
            prefixes[i] = proto.getSortedPrefixes(i).toByteArray();
        }
        return new MultipleColumnPrefixFilter(prefixes);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultipleColumnPrefixFilter)) {
            return false;
        }
        MultipleColumnPrefixFilter other = (MultipleColumnPrefixFilter)o;
        return this.sortedPrefixes.equals(other.sortedPrefixes);
    }

    @Override
    public Cell getNextCellHint(Cell kv) {
        return KeyValueUtil.createFirstOnRow(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength(), kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength(), this.hint, 0, this.hint.length);
    }

    public TreeSet<byte[]> createTreeSet() {
        return new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 == null || o2 == null) {
                    throw new IllegalArgumentException("prefixes can't be null");
                }
                byte[] b1 = (byte[])o1;
                byte[] b2 = (byte[])o2;
                return Bytes.compareTo(b1, 0, b1.length, b2, 0, b2.length);
            }
        });
    }

    @Override
    public String toString() {
        return this.toString(5);
    }

    protected String toString(int maxPrefixes) {
        StringBuilder prefixes = new StringBuilder();
        int count = 0;
        for (byte[] ba : this.sortedPrefixes) {
            if (count >= maxPrefixes) break;
            prefixes.append(Bytes.toStringBinary(ba));
            if (++count >= this.sortedPrefixes.size() || count >= maxPrefixes) continue;
            prefixes.append(", ");
        }
        return String.format("%s (%d/%d): [%s]", this.getClass().getSimpleName(), count, this.sortedPrefixes.size(), prefixes.toString());
    }
}

