/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.http;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hudi.org.apache.hadoop.hbase.http.HttpRequestLogAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.mortbay.jetty.NCSARequestLog;
import org.mortbay.jetty.RequestLog;

public class HttpRequestLog {
    private static final Log LOG = LogFactory.getLog(HttpRequestLog.class);
    private static final HashMap<String, String> serverToComponent = new HashMap();

    public static RequestLog getRequestLog(String name) {
        String lookup = serverToComponent.get(name);
        if (lookup != null) {
            name = lookup;
        }
        String loggerName = "http.requests." + name;
        String appenderName = name + "requestlog";
        Log logger = LogFactory.getLog((String)loggerName);
        if (logger instanceof Log4JLogger) {
            Log4JLogger httpLog4JLog = (Log4JLogger)logger;
            Logger httpLogger = httpLog4JLog.getLogger();
            Appender appender = null;
            try {
                appender = httpLogger.getAppender(appenderName);
            }
            catch (LogConfigurationException e) {
                LOG.warn((Object)("Http request log for " + loggerName + " could not be created"));
                throw e;
            }
            if (appender == null) {
                LOG.info((Object)("Http request log for " + loggerName + " is not defined"));
                return null;
            }
            if (appender instanceof HttpRequestLogAppender) {
                HttpRequestLogAppender requestLogAppender = (HttpRequestLogAppender)appender;
                NCSARequestLog requestLog = new NCSARequestLog();
                requestLog.setFilename(requestLogAppender.getFilename());
                requestLog.setRetainDays(requestLogAppender.getRetainDays());
                return requestLog;
            }
            LOG.warn((Object)("Jetty request log for " + loggerName + " was of the wrong class"));
            return null;
        }
        LOG.warn((Object)"Jetty request log can only be enabled using Log4j");
        return null;
    }

    static {
        serverToComponent.put("master", "master");
        serverToComponent.put("region", "regionserver");
    }
}

