/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.encoding;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public enum DataBlockEncoding {
    NONE(0, null),
    PREFIX(2, "org.apache.hudi.org.apache.hadoop.hbase.io.encoding.PrefixKeyDeltaEncoder"),
    DIFF(3, "org.apache.hudi.org.apache.hadoop.hbase.io.encoding.DiffKeyDeltaEncoder"),
    FAST_DIFF(4, "org.apache.hudi.org.apache.hadoop.hbase.io.encoding.FastDiffDeltaEncoder"),
    PREFIX_TREE(6, "org.apache.hudi.org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeCodec");

    private final short id;
    private final byte[] idInBytes;
    private DataBlockEncoder encoder;
    private final String encoderCls;
    public static final int ID_SIZE = 2;
    private static Map<Short, DataBlockEncoding> idToEncoding;

    private DataBlockEncoding(int id, String encoderClsName) {
        if (id < Short.MIN_VALUE || id > Short.MAX_VALUE) {
            throw new AssertionError((Object)("Data block encoding algorithm id is out of range: " + id));
        }
        this.id = (short)id;
        this.idInBytes = Bytes.toBytes(this.id);
        if (this.idInBytes.length != 2) {
            throw new RuntimeException("Unexpected length of encoder ID byte representation: " + Bytes.toStringBinary(this.idInBytes));
        }
        this.encoderCls = encoderClsName;
    }

    public byte[] getNameInBytes() {
        return Bytes.toBytes(this.toString());
    }

    public short getId() {
        return this.id;
    }

    public void writeIdInBytes(OutputStream stream) throws IOException {
        stream.write(this.idInBytes);
    }

    public void writeIdInBytes(byte[] dest, int offset) throws IOException {
        System.arraycopy(this.idInBytes, 0, dest, offset, 2);
    }

    public DataBlockEncoder getEncoder() {
        if (this.encoder == null && this.id != 0) {
            this.encoder = DataBlockEncoding.createEncoder(this.encoderCls);
        }
        return this.encoder;
    }

    public static DataBlockEncoder getDataBlockEncoderById(short encoderId) {
        if (!idToEncoding.containsKey(encoderId)) {
            throw new IllegalArgumentException(String.format("There is no data block encoder for given id '%d'", encoderId));
        }
        return idToEncoding.get(encoderId).getEncoder();
    }

    public static String getNameFromId(short encoderId) {
        return idToEncoding.get(encoderId).toString();
    }

    public static boolean isCorrectEncoder(DataBlockEncoder encoder, short encoderId) {
        if (!idToEncoding.containsKey(encoderId)) {
            throw new IllegalArgumentException(String.format("There is no data block encoder for given id '%d'", encoderId));
        }
        DataBlockEncoding algorithm = idToEncoding.get(encoderId);
        String encoderCls = encoder.getClass().getName();
        return encoderCls.equals(algorithm.encoderCls);
    }

    public static DataBlockEncoding getEncodingById(short dataBlockEncodingId) {
        return idToEncoding.get(dataBlockEncodingId);
    }

    protected static DataBlockEncoder createEncoder(String fullyQualifiedClassName) {
        try {
            return (DataBlockEncoder)Class.forName(fullyQualifiedClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static {
        idToEncoding = new HashMap<Short, DataBlockEncoding>();
        for (DataBlockEncoding algo : DataBlockEncoding.values()) {
            if (idToEncoding.containsKey(algo.id)) {
                throw new RuntimeException(String.format("Two data block encoder algorithms '%s' and '%s' have the same id %d", idToEncoding.get(algo.id).toString(), algo.toString(), (int)algo.id));
            }
            idToEncoding.put(algo.id, algo);
        }
    }
}

